DELIMITER $$
DROP PROCEDURE IF EXISTS V20200823131429__Update_sqldtproviderRejectApplication $$
CREATE PROCEDURE V20200823131429__Update_sqldtproviderRejectApplication()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_RECIPIENTS');
IF EXISTS ((select * from sql_dtprovider where dataProviderId = @dtproviderId)) THEN 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "select T1.id AS ID,
	T3.`salutationName` AS SALUTATION_NAME,
	T2.`firstName` AS FIRST_NAME,
	T2.`middleName` AS MIDDLE_NAME,
	T2.`lastName` AS LAST_NAME,
	T2.`emailId` AS EMAIL_ID,
	T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` as APPLICATION_CODE,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T7.addressText,' ',T8.cityName,', ',T9.countryName,', ',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T11.programName AS PROGRAM_NAME,
    T13.batchName AS BATCH_NAME,
    T14.printName AS APPLICATION_OWNER_NAME,
    (CASE
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
    END) AS LOGO_URL
    from application T1 
		left outer join
    applicant_person T2 on T1.applicantPersonId=T2.id
		inner join
	salutations T3 on T3.id = T2.salutationId
		LEFT JOIN
    application_program T4 ON T4.applicationId = T1.id
		LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T6 ON T6.academyLocationId = T5.id
		LEFT OUTER JOIN
    address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
		LEFT OUTER JOIN
	city T8 ON T8.id = T7.cityId
		LEFT OUTER JOIN
	country T9 ON T9.id = T8.countryId
		LEFT OUTER JOIN
	country_region T10 ON T10.id = T8.countryRegionId
		LEFT OUTER JOIN
	programs T11 ON T11.id = T4.programId
		LEFT JOIN
	batches T13 ON T13.programId=T11.id
		LEFT JOIN
	users T14 ON T14.id=T1.applicationOwner
		LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    where T1.id in(namedParams) group by T1.id",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "Academy Location Phone No.",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Academy Location Email Id",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "Program Name",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "Batch Name",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "Application Owner Name",
            "resultKey": "APPLICATION_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 15
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200823131429__Update_sqldtproviderRejectApplication () $$
DROP PROCEDURE IF EXISTS V20200823131429__Update_sqldtproviderRejectApplication $$
DELIMITER ;