DELIMITER $$
DROP PROCEDURE IF EXISTS V20200903183209__Insert_D3_Report $$
CREATE PROCEDURE V20200903183209__Insert_D3_Report()
BEGIN
	
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'D3_ASSESSMENT_REPORT' )) THEN 
set @reportName1 = (select id from report_type WHERE typeName = 'Examination Foils Report');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@reportName1, 'D3_ASSESSMENT_REPORT', 'D-3 Assessment report', 'D3_ASSESSMENT_REPORT.png', 'D3_CommonReport_PageNumber.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'D3_ASSESSMENT_REPORT.jasper', 'AcademiaLogo.png'); 


set @degreeAuditReportID = (select id from report_template where templateCode ='D3_ASSESSMENT_REPORT');
	
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES(@degreeAuditReportID, 'TRANS_PROGRESSIVE', 'PROGRESSIVE ASSESSMENT OF PRACTICALS', '1', now()),
(@degreeAuditReportID, 'TRANS_ACADEMIC_Y', 'Academic Year:', '1', now()),
(@degreeAuditReportID, 'TRANS_PROGRAM', 'Program:', '1', now()),
(@degreeAuditReportID, 'TRANS_COURSE', 'Course:', '1', now()),
(@degreeAuditReportID, 'TRANS_COURSE_CODE', 'Course Code:', '1', now()),
(@degreeAuditReportID, 'TRANS_SEMESTER', 'Semester:', '1', now()),
(@degreeAuditReportID, 'TRANS_FACULTY_NAME', 'Name of Faculty:', '1', now()),
(@degreeAuditReportID, 'TRANS_ROLLNO', 'Roll No.', '1', now()),
(@degreeAuditReportID, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now()),
(@degreeAuditReportID, 'TRANS_EXAM_SEATNO', 'Exam Seat No.', '1', now()),
(@degreeAuditReportID, 'TRANS_STD_NAME', 'Name of the Student', '1', now()),	
(@degreeAuditReportID, 'TRANS_EXPERIMENT', 'Experiment/Job/Assignment/Sheet/Activity of Project (Marks out of 10 per experiment)', '1', now()),	
(@degreeAuditReportID, 'TRANS_TOTAL_MARKS', 'Total Marks out of (10 x No. of Expt.)', '1', now()),	
(@degreeAuditReportID, 'TRANS_PA_MARKS', 'PA Marks of Practical Converted According to T.E. Scheme', '1', now()),	
(@degreeAuditReportID, 'TRANS_SIGN_FACULTY', '(Name & Signature of Faculty)', '1', now()),
(@degreeAuditReportID, 'TRANS_SIGN_HOD', '(Name & Signature of HOD)', '1', now());			

END IF;
END $$
CALL V20200903183209__Insert_D3_Report() $$
DROP PROCEDURE IF EXISTS V20200903183209__Insert_D3_Report $$
DELIMITER ;
