DELIMITER $$
DROP PROCEDURE IF EXISTS V20200928170023__Insert_ReportTempTranVGUStudentBill $$
CREATE PROCEDURE V20200928170023__Insert_ReportTempTranVGUStudentBill()
BEGIN
set @id = (SELECT id FROM report_template WHERE reportTypeId=3 and templateCode = 'MANAGE_BILLS_STUDENT_CODE' and templateName='VGU Student Bill');

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_PAYMENT_DUE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_PAYMENT_DUE', 'Payment due: 30 days from date of debit note', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_PAYMENT_DETAILS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_PAYMENT_DETAILS', 'Payment Details :', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_ACCOUNT_HOLDER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_ACCOUNT_HOLDER', '- Account holder: Trường Đại Học Việt Đức', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_ACCOUNT_NO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_ACCOUNT_NO', '- Account No.: 037 100 3883479', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_BANK_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_BANK_NAME', '- Bank name: Vietcombank Tân Định – Tp HCM', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_SWIFF_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_SWIFF_CODE', '- Swiff code: BFTV VNVX', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_REMARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_REMARKS', '- Remarks: Student ID, Full Name, Class (Program&intake), payment for tuition fee of …', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_CONTACT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_CONTACT', 'Contact:', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_THE_ACCOUNTANT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_THE_ACCOUNTANT', '-          Ms. Le Hong Duyen, the Accountant.', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_EMAIL_VGU')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_EMAIL_VGU', '-          Email: duyen.lh@vgu.edu.vn', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='TRANS_PHONE_VGU')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'TRANS_PHONE_VGU', '-          Phone: 0274. 2220990 – Ext: 102', '1', NOW());
END IF; 

IF NOT EXISTS ((select * from `report_template_translations` where `reportTemplateId`=@id and `keyValue`='HEAD_OF_FINANCE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@id, 'HEAD_OF_FINANCE', 'HEAD OF FINANCE - ACCOUNTING DEPARTMENT', '1', NOW());
END IF;

END $$
CALL V20200928170023__Insert_ReportTempTranVGUStudentBill() $$
DROP PROCEDURE IF EXISTS V20200928170023__Insert_ReportTempTranVGUStudentBill $$
DELIMITER ;