DELIMITER $$
DROP PROCEDURE IF EXISTS V20201010145811__Insert_ContactDetailsReport $$
CREATE PROCEDURE V20201010145811__Insert_ContactDetailsReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Employee Job Posting' )) THEN
INSERT INTO `report_type` (`typeName`) VALUES ('Employee Job Posting'); 
END IF; 
	
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'APPLICANT_CONTACT_DETAILS_REPORT' )) THEN 
set @contact = (select id from report_type WHERE typeName = 'Employee Job Posting');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@contact, 'APPLICANT_CONTACT_DETAILS_REPORT', 'Contact Details', 'CONTACT_DETAILS_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'CONTACT_DETAILS_REPORT.jasper', 'AcademiaLogo.png'); 



set @details = (select id from report_template where templateCode ='APPLICANT_CONTACT_DETAILS_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_APPLICATION_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_APPLICATION_ID', 'Job Applicant ID', '1', now());
 END IF;
 
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_APPLICATION_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_APPLICATION_NAME', 'Job Applicant Name', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_JOB_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_JOB_CODE', 'Job Code', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_JOB_TITLE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_JOB_TITLE', 'Job Title', '1', now());
 END IF;

 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @details and keyValue='TRANS_JOB_DESIGNATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@details, 'TRANS_JOB_DESIGNATION', 'Job Designation', '1', now());
 END IF;


END IF; 

END $$
CALL V20201010145811__Insert_ContactDetailsReport() $$
DROP PROCEDURE IF EXISTS V20201010145811__Insert_ContactDetailsReport $$
DELIMITER ;
