DELIMITER $$
DROP PROCEDURE IF EXISTS V20201022112643__Create_bank_charges $$
CREATE PROCEDURE V20201022112643__Create_bank_charges()
BEGIN

IF NOT EXISTS (((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='bank_charges'))) THEN 
CREATE TABLE `bank_charges`(
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`feePaymentModeId` bigint(20) DEFAULT NULL,
`bankDrawnMasterId` bigint(20) DEFAULT NULL,
`fromDate` date DEFAULT NULL,
`toDate` date DEFAULT NULL,
`bankChargesApplicable` int(3) DEFAULT NULL,
`lastUpdatedBy` bigint(20) DEFAULT NULL,
`lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
 PRIMARY KEY(`ID`),
KEY `FeeMode_FK_1_idx`(`feePaymentModeId`), 
KEY `BankMaster_FK_2_idx`(`bankDrawnMasterId`),
KEY `USER_FK_3_idx` (`lastUpdatedBy`),
CONSTRAINT `FK_bank_charges_feePaymentModeId` FOREIGN KEY (`feePaymentModeId`) REFERENCES `fee_payment_modes`(`id`)ON DELETE NO ACTION ON UPDATE NO ACTION,
CONSTRAINT `FK_bank_charges_bankDrawnMasterId` FOREIGN KEY (`bankDrawnMasterId`) REFERENCES `bank_drawn_on_master`(`id`)ON DELETE NO ACTION ON UPDATE NO ACTION,
CONSTRAINT `fk_bank_charges_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
)ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201022112643__Create_bank_charges () $$ 
DROP PROCEDURE IF EXISTS V20201022112643__Create_bank_charges $$ 
DELIMITER ;