DELIMITER $$
DROP PROCEDURE IF EXISTS V20201111132300__Create_CourseFeeSubFeeHead $$
CREATE PROCEDURE V20201111132300__Create_CourseFeeSubFeeHead()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_fee_sub_fee_head')) THEN 
CREATE TABLE `course_fee_sub_fee_head` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseFeeDefinationId` bigint NOT NULL,
  `serialNo` bigint NOT NULL,
  `feeHeadId` bigint NOT NULL,
  `amountOrWeightage` double(20,2) DEFAULT NULL,
  `costCentreId` bigint DEFAULT NULL,
  `isRefundable` bit(1) DEFAULT NULL,
  `droolRuleId` bigint DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_course_fee_sub_fee_head_to_course_fee_defination_idx` (`courseFeeDefinationId`),
  KEY `fk_course_fee_sub_fee_head_to_fee_heads_idx` (`feeHeadId`),
  KEY `fk_course_fee_sub_fee_head_to_cost_centre_idx` (`costCentreId`),
  KEY `fk_course_fee_sub_fee_head_to_drool_rule_idx` (`droolRuleId`),
  KEY `fk_course_fee_sub_fee_head_to_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_course_fee_sub_fee_head_to_cost_centre` FOREIGN KEY (`costCentreId`) REFERENCES `cost_centre` (`id`),
  CONSTRAINT `fk_course_fee_sub_fee_head_to_course_fee_defination` FOREIGN KEY (`courseFeeDefinationId`) REFERENCES `academic_award` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_sub_fee_head_to_drool_rule` FOREIGN KEY (`droolRuleId`) REFERENCES `drool_rules` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_sub_fee_head_to_fee_heads` FOREIGN KEY (`feeHeadId`) REFERENCES `fee_heads` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_sub_fee_head_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201111132300__Create_CourseFeeSubFeeHead () $$ 
DROP PROCEDURE IF EXISTS V20201111132300__Create_CourseFeeSubFeeHead $$ 
DELIMITER ;