DELIMITER $$
DROP PROCEDURE IF EXISTS V20201111161732__Create_CourseRepetitionFeeDefination $$
CREATE PROCEDURE V20201111161732__Create_CourseRepetitionFeeDefination()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_repetition_fee_defination')) THEN 
CREATE TABLE `course_repetition_fee_defination` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `courseFeeDefinationId` bigint NOT NULL,
  `enrollmentNo` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_course_repetition_fee_defination_to_course_fee_definatio_idx` (`courseFeeDefinationId`),
  KEY `fk_course_repetition_fee_defination_to_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_course_repetition_fee_defination_to_course_fee_defination` FOREIGN KEY (`courseFeeDefinationId`) REFERENCES `course_fee_defination` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_repetition_fee_defination_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201111161732__Create_CourseRepetitionFeeDefination () $$ 
DROP PROCEDURE IF EXISTS V20201111161732__Create_CourseRepetitionFeeDefination $$ 
DELIMITER ;
