DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_subjectenrolmentdetails //
CREATE  PROCEDURE sp_tvet_subjectenrolmentdetails()
BEGIN

select per.nationalID as National_Id,
iddetail.idNumber as Person_Alternate_Id,
iddetail.itemCode as Alternate_Id_Type_Id,
'' as Unit_Standard_Id,
case when stuce.exitDate is not null then 10 else 3 end as Enrolment_Status_Id,
per.externalSysRefOne as Staff_Number,
modo.itemCode as Enrolment_Type_Id,
case when stuce.exitDate is not null then stuce.exitDate else stuce.enrollmentDate end Enrolment_Status_Date,
stuce.enrollmentDate as Enrolment_Date,
'' as Filler01,aaw.itemCode as Part_Of_Id,
case when aaw.itemCode='2' then prog.programRegistrationId else '' end Qualification_Id,
case when aaw.itemCode='3' then prog.programRegistrationId else '' end Learnership_Id,
loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,'' as Filler02,course.courseCode as Subject_Code,
prog.programCode as Programme_Code,
'' as Enrolment_Status_Reason_Id,
stuce.enrollmentDate as Most_Recent_Registration_Date,
rt.itemCode as Enrolment_Mode_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
 from
student_course_enrollment stuce
left join prog_batch_period_config progbpc on(progbpc.id=stuce.programBatchPeriodConfigId)
left join batches btc on(btc.id=progbpc.programBatchId)
left join programs prog on(prog.id=btc.programId)
join admission adm on (stuce.admissionId=adm.id)
join students stu on(stu.userId=adm.studentId)
join mode_of_delivery modo on(btc.modeOfDeliveryId=modo.id)
join persons per on(per.id=stu.personId)
left join academic_award aaw on(aaw.id=prog.academicAwardId)
left join course_variants cv on(stuce.courseVarientId=cv.id)
left join courses course on(course.id=cv.courseId)
left join registration_type rt on(prog.registrationTypeId=rt.id)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
left join academy_location al on(al.id=prog.academyLocationId)
left join locations loc on(loc.id=al.locationId)
where year(now()) between year(btc.startDate) and year(btc.tillDate) group by stuce.id;

END//
DELIMITER ;