DELIMITER $$
DROP PROCEDURE IF EXISTS V20201127133202__Create_po_indirect_view $$
CREATE PROCEDURE V20201127133202__Create_po_indirect_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'po_indirect_view')) THEN 
DROP view `po_indirect_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'po_indirect_view')) THEN 
create or replace VIEW `po_indirect_view` AS
    SELECT 
        `al`.`id` AS `academyLocationId`,
        `al`.`academyCode` AS `academyCode`,
        `al`.`academyName` AS `academyName`,
        `al`.`displayName` AS `displayName`,
        `al`.`locationName` AS `locationName`,
        `act`.`itemValue` AS `Academic_Term`,
        `btc`.`batchName` AS `Batch`,
        `proggr`.`groupName` AS `Program_Group`,
        `prog`.`programCode` AS `programCode`,
        `prog`.`programShortName` AS `programShortName`,
        `prog`.`programNameToBePrint` AS `Program`,
        `manageat`.`directAttainmentWeightage` AS `Indirect_Contribute_Percentage`,
        `programOutComestType`.`code` AS `outcomesType`,
        `managepo`.`programOutComeCode` AS `Program_Outcome`,
        `managepo`.`indirectAttainment` AS `PO_Indirect_Average`
    FROM
        ((((((((`manage_program_outcomes` `managepo`
        LEFT JOIN `batches` `btc` ON ((`managepo`.`batchId` = `btc`.`id`)))
        LEFT JOIN `program_out_comes_type` `programOutComestType` ON ((`programOutComestType`.`id` = `managepo`.`outcomesType`)))
        LEFT JOIN `programs` `prog` ON ((`btc`.`programId` = `prog`.`id`)))
        LEFT JOIN `academy_location` `al` ON ((`prog`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `prog_batch_period_config` `progbpc` ON ((`progbpc`.`programBatchId` = `btc`.`id`)))
        LEFT JOIN `academic_term` `act` ON ((`act`.`id` = `progbpc`.`academicTermId`)))
        LEFT JOIN `program_group` `proggr` ON ((`prog`.`programGroupId` = `proggr`.`id`)))
        LEFT JOIN `manage_attainment` `manageat` ON ((`manageat`.`id` = `managepo`.`manageAttainmentId`)))
    GROUP BY `managepo`.`id`;
END IF; 

END $$
CALL V20201127133202__Create_po_indirect_view () $$ 
DROP PROCEDURE IF EXISTS V20201127133202__Create_po_indirect_view $$ 
DELIMITER ;