DELIMITER $$
DROP PROCEDURE IF EXISTS V20201222173733__Create_placementDriveFollowup $$
CREATE PROCEDURE V20201222173733__Create_placementDriveFollowup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='placement_drive_followup')) THEN 
CREATE TABLE `placement_drive_followup` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `driveId` bigint DEFAULT NULL,
  `followUpUser` bigint DEFAULT NULL,
  `followUpActivityUser` bigint DEFAULT NULL,
  `followUpDate` datetime DEFAULT NULL,
  `actualFollowUpDate` datetime DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `isLatestFollowUp` bit(1) DEFAULT NULL,
  `reasonForFollowUp` varchar(255) DEFAULT NULL,
  `followupTime` time DEFAULT NULL,
  `followupName` bigint DEFAULT NULL,
  `activityType` bigint DEFAULT NULL,
  `followupStatus` bigint DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_placement_followup_user_idx` (`followUpUser`),
  KEY `fk_placement_followupactivity_user_idx` (`followUpActivityUser`),
  KEY `fk_placement_follow_drive_idx` (`driveId`),
  KEY `fk_placement_followup_name_idx` (`followupName`),
  KEY `fk_placement_followup_activity_idx` (`activityType`),
  KEY `fk_placement_followup_status_idx` (`followupStatus`),
  KEY `fk_placement_followup_lastupdate_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_placement_follow_drive` FOREIGN KEY (`driveId`) REFERENCES `placement_campus` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_placement_followup_activity` FOREIGN KEY (`activityType`) REFERENCES `placement_activitytype_csm` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_placement_followup_lastupdate` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_placement_followup_name` FOREIGN KEY (`followupName`) REFERENCES `placement_followupname_csm` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_placement_followup_status` FOREIGN KEY (`followupStatus`) REFERENCES `placement_followupstatus_csm` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_placement_followup_user` FOREIGN KEY (`followUpUser`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_placement_followupactivity_user` FOREIGN KEY (`followUpActivityUser`) REFERENCES `academy_location_contacts` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ;

END IF; 

END $$
CALL V20201222173733__Create_placementDriveFollowup () $$ 
DROP PROCEDURE IF EXISTS V20201222173733__Create_placementDriveFollowup $$ 
DELIMITER ;