DELIMITER $$
DROP PROCEDURE IF EXISTS V20201223163303__Alter_SAP_Student_Detail_View $$
CREATE PROCEDURE V20201223163303__Alter_SAP_Student_Detail_View()
BEGIN

DROP VIEW IF EXISTS `sap_student_detail_view`;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='sap_student_detail_view')) THEN 
CREATE    
VIEW `sap_student_detail_view` AS
SELECT
usr.firstName AS First_Name,
usr.middleName AS Middle_Name,
usr.lastName AS Last_Name,
gen.itemValue AS Gender,
per.birthDate AS Date_Of_Birth,
cntry.countryName AS Country,
per.nationalID AS Id_Card_No,
usr.code AS ID,
usr.status AS Status,
adr.addressText AS Address,
concat(per.phoneAreaCode," ",per.phoneNo) AS Phone_No,
per.mobileNumber AS Mobile_No,
per.emailId AS Email,
per.alternateEmailId AS Alt_Email,
usr.printName AS Name_In_Bank,
bd.accountNumber AS Bank_Acc_No,
at.itemValue AS Bank_Acc_Type,
bd.bankName AS Bank_Name,
bd.branchName AS Bank_Branch_Name,
bd.IFSCode AS Bank_IFSC_Code,
stp.seatName AS Seat_Type,
per.lastUpdate as Last_Update
FROM 
students std
INNER JOIN users usr on std.userId=usr.id
INNER JOIN persons per on std.personId=per.id
LEFT JOIN person_addresses peradd on per.id=peradd.personId
LEFT JOIN address adr on adr.id=peradd.addressId
LEFT JOIN gender gen on per.genderId=gen.id
LEFT JOIN country cntry on per.countryId=cntry.id
LEFT JOIN bank_details bd on per.bankDetailId=bd.id
LEFT JOIN account_type at on bd.accountTypeId=at.id
LEFT JOIN admission adm on std.userId=adm.studentId
LEFT JOIN program_batch_students pbs on pbs.admissionId=adm.id
LEFT JOIN prog_batch_seat_config pbsc on pbsc.id=pbs.progBatchSeatConfigId
LEFT JOIN seat_types stp on stp.id=pbsc.seatTypeId
where pbs.isCurrentPeriod =true and pbs.isCurrentSection=true
and pbs.isPeriodCompleted=false and peradd.whetherPrimary=true
GROUP BY usr.id;
END IF; 

END $$
CALL V20201223163303__Alter_SAP_Student_Detail_View() $$
DROP PROCEDURE IF EXISTS V20201223163303__Alter_SAP_Student_Detail_View $$
DELIMITER ;