DELIMITER $$
DROP PROCEDURE IF EXISTS V20210105175058__Create_thesis_mgt_status $$
CREATE PROCEDURE V20210105175058__Create_thesis_mgt_status()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='thesis_management_status')) THEN 
CREATE TABLE `thesis_management_status` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `thesisManagementId` BIGINT(20) NOT NULL,
  `status` VARCHAR(45) NOT NULL,
  `statusDate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `remarks` VARCHAR(100) DEFAULT NULL,
  `accessModeId` BIGINT(20) DEFAULT NULL,
  `accessModeDate` TIMESTAMP NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_thesis_management_id_idx` (`thesisManagementId` ASC),
  INDEX `fk_thesis_users_doc_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_thesis_management_id`
    FOREIGN KEY (`thesisManagementId`)
    REFERENCES `thesis_management` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_thesis_document_id`
    FOREIGN KEY (`accessModeId`)
    REFERENCES `drop_down` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_thesis_users_doc_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 
 
END $$
CALL V20210105175058__Create_thesis_mgt_status () $$ 
DROP PROCEDURE IF EXISTS V20210105175058__Create_thesis_mgt_status $$ 
DELIMITER ;