DELIMITER $$

DROP PROCEDURE IF EXISTS V20210106151812__DFRAndTransforPersonInfo $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210106151812__DFRAndTransforPersonInfo()

BEGIN
 
  -- Insert new record in ui_translation table, if it doesn't already exist
    IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and formFieldId = 'isAgencyRequiredField' )) THEN
       
    INSERT INTO `form_field_info` 
    (`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
    VALUES ('personalinformationform', 'isAgencyRequired', 'isAgencyRequiredField', 'checkboxfield', 0, 0, 1, now(), 'Is Agency Recruited', 'Personal Details Info', 'Create, Edit, and View', 'Is Agency Recruited', 0);

    END IF;

    IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and formFieldId = 'postNumberId' )) THEN
       
    INSERT INTO `form_field_info` 
    (`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
    VALUES ('personalinformationform', 'postNumber', 'postNumberId', 'textfield', 0, 0, 1, now(), 'Post Number', 'Personal Details Info', 'Create, Edit, and View', 'Post Number', 0);

    END IF;

    IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'personalinformationform' and formFieldId = 'hpcsaRegNoId' )) THEN
       
    INSERT INTO `form_field_info` 
    (`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
    VALUES ('personalinformationform', 'hpcsaRegNo', 'hpcsaRegNoId', 'textfield', 0, 0, 1, now(), 'HPCSA Registration Number', 'Personal Details Info', 'Create, Edit, and View', 'HPCSA Registration Number', 0);

    END IF;

    IF NOT EXISTS (((select * from ui_translation where objectName = 'PERSON' and keyName = 'IS_AGENCY_RECRUITED'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('PERSON', 'IS_AGENCY_RECRUITED', 'Is Agency Recruited', 'Is Agency Recruited', 'Is agentskap gewerf', 'Đại lý được tuyển dụng',now(),1);
    END IF;
    
    IF NOT EXISTS (((select * from ui_translation where objectName = 'PERSON' and keyName = 'POST_NUMBER'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('PERSON', 'POST_NUMBER', 'Post Number', 'Post Number', 'Posnommer', 'Số bài viết',now(),1);
    END IF;
    
    IF NOT EXISTS (((select * from ui_translation where objectName = 'PERSON' and keyName = 'HPCSA_REG_NO'))) THEN 
        INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `afriLanguage`, `vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
                VALUES ('PERSON', 'HPCSA_REG_NO', 'HPCSA Registration Number', 'HPCSA Registration Number', 'HPCSA-registrasienommer', 'Số đăng ký HPCSA',now(),1);
    END IF;

END $$


-- Execute the stored procedure
CALL V20210106151812__DFRAndTransforPersonInfo() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210106151812__DFRAndTransforPersonInfo $$
 
DELIMITER ;