DELIMITER $$
DROP PROCEDURE IF EXISTS V20210114095211__Create_DocumentStatusTypeAndSize $$
CREATE PROCEDURE V20210114095211__Create_DocumentStatusTypeAndSize()
BEGIN
-- create table
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='document_master_type')) THEN 
CREATE TABLE `document_master_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `documentMasterId` bigint(20)  NULL,
  `fileTypeId` bigint(20)  NULL,
  `size` int  NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
   `lastUpdatedBy` BIGINT(20),
   `version` decimal(10,0),
   PRIMARY KEY (`id`),
  KEY `fk_document_status_lastUpdatedBy_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_document_status_type_size_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_document_status_type_documentStatusId` FOREIGN KEY (`documentMasterId`) REFERENCES `placement_document_master` (`id`),
   CONSTRAINT `fk_document_status_type_fileTypeId` FOREIGN KEY (`fileTypeId`) REFERENCES `file_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

-- insert masterName
IF NOT EXISTS ((SELECT * FROM `standard_master` WHERE masterName ='DOCUMENT_MASTER_TYPE' and tableName='document_master_type')) THEN 
INSERT INTO `standard_master`
(`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`,`droolsAgenda`,`displayValue`,`lastUpdatedBy`,
`lastUpdate`)
VALUES(NULL,'document_master_type','DOCUMENT_MASTER_TYPE','General Setup','COMMON_MASTER',1,0,NULL,NULL,1,now());
END IF; 

set @documentStatusId = (SELECT id FROM `standard_master` WHERE masterName ='DOCUMENT_MASTER_TYPE');

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM standard_master WHERE masterName = 'PLACEMENT_DOCUMENT_MASTER')) THEN 
UPDATE	`standard_master` SET `childMaster`=@documentStatusId  WHERE  masterName = 'PLACEMENT_DOCUMENT_MASTER' AND `childMaster` is null  ;
UPDATE	`standard_master` SET `whetherParent`=1  WHERE  masterName = 'PLACEMENT_DOCUMENT_MASTER' AND `whetherParent` =0  ;
END IF;
SET SQL_SAFE_UPDATES=1;
 
-- Update masterName
IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'document_master_type');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('fileType','FILE_TYPE',@standardMasterId,'Varchar',NULL,1,1,'file_type','id','itemValue',0,0,1,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('size','MAX_SIZE_IN_KB',@standardMasterId,'Number',NULL,2,0,NULL,NULL,NULL,0,0,1,NULL,NULL,NULL,1,now());

END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName ='TRANSLATIONS' and keyName='MAX_SIZE_IN_KB')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','MAX_SIZE_IN_KB','Max Size (KB)','Max Size (KB)','Maksimum grootte (KB)','Kích thước tối đa (KB)',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName ='TRANSLATIONS' and keyName='FILE_TYPE')) THEN 
INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','FILE_TYPE','File Type','File Type','Leër tipe','Loại tệp',now(),1);
END IF; 

END $$
CALL V20210114095211__Create_DocumentStatusTypeAndSize () $$ 
DROP PROCEDURE IF EXISTS V20210114095211__Create_DocumentStatusTypeAndSize $$ 
DELIMITER ;