DELIMITER $$
DROP PROCEDURE IF EXISTS V20210118103758__Create_credit_note_view_sapb1 $$
CREATE PROCEDURE V20210118103758__Create_credit_note_view_sapb1()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='credit_note_view_sapb1')) THEN 
CREATE VIEW credit_note_view_sapb1 AS
SELECT 
    bfprs.id AS CreditNoteFeeHeadId,
    bh.billNo AS CreditNoteNo,
    bh.raiseBillType AS CreditNoteType,
    but.billedUserType AS CreditNoteFor,
    c.currencyCode AS CreditNoteCurrency,
    bh.billingDate AS CreditNoteDate,
    (CASE
        WHEN (bh.applicantId IS NOT NULL) THEN CONCAT(a.code, '/', ap.printName)
        WHEN (bh.studentId IS NOT NULL) THEN CONCAT(st_user.code, '/', st_user.printName)
        WHEN (bh.sponsorId IS NOT NULL) THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
        WHEN (bh.userId IS NOT NULL) THEN CONCAT(u.code, '/', u.printName)
        ELSE NULL
    END) AS CreditNoteOwner,
    (SELECT 
            pbpc.programPeriodName
        FROM
            program_batch_students pbs
                LEFT JOIN
            prog_batch_period_config pbpc ON pbs.progBatchPeriodConfigId = pbpc.id
                LEFT JOIN
            admission adm ON adm.id = pbs.admissionId
                LEFT JOIN
            students st ON st.userId = adm.studentId
        WHERE
            st.userId = bh.studentId
                AND bh.billingDate >= pbpc.programPeriodStart
                AND bh.billingDate <= pbpc.programPeriodEnd
        GROUP BY st.userId) AS Semester,
    CONCAT(pgm.programName,
            '#',
            b.batchName,
            '#',
            seat.seatName) AS programIntakeSeatType,
    pgmb.groupName AS ProgramGroup,
    pgm.programCode AS ProgramCode,
    ou.code AS CreditNoteIAU,
    bh.dueDate AS DueDate,
    fh.feeHeadName AS FeeHeadName,
    bfprs.billableAmount AS Amount,
    bh.reasonForManualBill AS ReasonForManualBilling,
    fpt.feePlanType AS FeePlanType,
    fp.feePlanId AS FeePlanId,
    fpr.feeRuleDesc AS FeePlanRule,
    fsm.stageName AS FeePlanStage,
    bh.billStatus AS BillStatus,
    sch.scholarshipName AS ScholarshipName,
    (CASE
        WHEN sch.scholarshipType = 'EXT' THEN 'External'
        WHEN sch.scholarshipType = 'INT' THEN 'Internal'
        ELSE NULL
    END) AS ScholarshipType,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.payerType
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS FeePayerType,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.companyName
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS NameOfCompany,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.firstName
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS NameOfContactPerson,
    (SELECT 
            GROUP_CONCAT(DISTINCT CONCAT(ad.addressText,
                            ',',
                            ci.cityName,
                            ',',
                            cou.countryName)
                    SEPARATOR '#')
        FROM
            fee_payer_detail fpd
                LEFT OUTER JOIN
            address ad ON ad.id = fpd.addressId
                LEFT OUTER JOIN
            city ci ON ci.id = ad.cityId
                LEFT OUTER JOIN
            country cou ON cou.id = ci.countryId
        WHERE
            fpd.personId = p.id
                AND fpd.addressId IS NOT NULL) AS Address,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.companyAddress
                    SEPARATOR '#')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS CompanyAddress,
    (SELECT 
            GROUP_CONCAT(DISTINCT fpd.corporateId
                    SEPARATOR ',')
        FROM
            fee_payer_detail fpd
        WHERE
            fpd.personId = p.id) AS CorporateId,
    bh.lastUpdate AS LastUpdate
FROM
    bill_fee_plan_rule_stage bfprs
        LEFT JOIN
    bill_header bh ON bfprs.billId = bh.id
        LEFT JOIN
    currency c ON c.id = bh.currencyId
        LEFT JOIN
    students st ON st.userId = bh.studentId
        LEFT JOIN
    sponsors sp ON sp.id = bh.sponsorId
        LEFT JOIN
    organization_units ou ON bh.iauId = ou.id
        LEFT JOIN
    application a ON a.id = bh.applicantId
        LEFT JOIN
    applicant_person ap ON ap.id = a.applicantPersonId
        LEFT JOIN
    users u ON u.id = bh.userId
        LEFT JOIN
    users st_user ON st_user.id = st.userId
        LEFT JOIN
    persons p ON p.id = st.personId
        LEFT JOIN
    billed_user_type but ON but.id = bh.raiseBillFor
        LEFT JOIN
    prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
        LEFT JOIN
    batches b ON b.id = pbsc.programBatchId
        LEFT JOIN
    programs pgm ON b.programId = pgm.id
        LEFT JOIN
    program_group pgmb ON pgmb.id = pgm.programGroupId
        LEFT JOIN
    seat_types seat ON seat.id = pbsc.seatTypeId
        LEFT JOIN
    fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
        LEFT JOIN
    fee_heads fh ON fshc.feeHeadId = fh.id
        LEFT JOIN
    fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
        LEFT JOIN
    fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
        LEFT JOIN
    fee_plan fp ON fp.id = fpr.feePlanId
        LEFT JOIN
    fee_plan_type fpt ON fpt.id = fp.feePlanType
        LEFT JOIN
    fee_stage_master fsm ON fsm.id = fprs.stageId
        LEFT JOIN
    scholarship sch ON sch.id = bh.scholarshipId
WHERE
    bh.raiseBillCategory = 'BILL_PAYABLE'
GROUP BY bfprs.id;
END IF; 

END $$
CALL V20210118103758__Create_credit_note_view_sapb1 () $$ 
DROP PROCEDURE IF EXISTS V20210118103758__Create_credit_note_view_sapb1 $$ 
DELIMITER ;
