DELIMITER $$
DROP PROCEDURE IF EXISTS V20210213142455__Insert_NECBRRecSettleStudent $$
CREATE PROCEDURE V20210213142455__Insert_NECBRRecSettleStudent()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '4' AND templateCode = 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' AND templateName='Receipt Settlement NECB Student')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('4', 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'Receipt Settlement NECB Student', 'SettlementTriplicateCollege.png', 'CommonReport_LandScape_pageNo_LeftCenterRight.jasper', 'All', '0', 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', '0', '0', 'NECBTriplicateWithParamStudent_1.jasper', 'AcademiaLogo.png');


set @reportTempId= (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE');
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId , 'TRANS_RECEIPTNO', 'Receipt No.', '1', NOW()),
(@reportTempId , 'TRANS_DATE', 'Date', '1', NOW()),
(@reportTempId , 'TRANS_RECEIVED_FROM', 'Received From', '1', NOW()),
(@reportTempId , 'TRANS_FATHER_NAME', 'Guardian', '1', NOW()),
(@reportTempId , 'TRANS_ID', 'Id', '1', NOW()),
(@reportTempId , 'TRANS_ACADEMY_NAME', 'Faculty', '1', NOW()),
(@reportTempId , 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@reportTempId , 'TRANS_PROCESSED_BY', 'Processed By', '1', NOW()),
(@reportTempId , 'TRANS_REMARK', 'Remark', '1', NOW()),
(@reportTempId , 'TRANS_SR_NO', 'Sr. No.', '1', NOW()),
(@reportTempId , 'TRANS_PARTICULAR', 'Details', '1', NOW()),
(@reportTempId , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@reportTempId , 'TRANS_BANK_REFERENCE', 'Bank reference', '1', NOW()),
(@reportTempId , 'TRANS_CASH_RECEIVED', 'Received In Cash', '1', NOW()),
(@reportTempId , 'TRANS_BANK_NAME', 'Bank Name', '1', NOW());
END IF; 

END $$
CALL V20210213142455__Insert_NECBRRecSettleStudent() $$
DROP PROCEDURE IF EXISTS V20210213142455__Insert_NECBRRecSettleStudent $$
DELIMITER ;