DELIMITER $$
DROP PROCEDURE IF EXISTS V20210215110024__Insert_UITranslation $$
CREATE PROCEDURE V20210215110024__Insert_UITranslation()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='PASSWORD_IS_NOT_FOLLOWING_PASSWORD_POLICY')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','PASSWORD_IS_NOT_FOLLOWING_PASSWORD_POLICY','Password is not Following Password Policy','Password is not Following Password Policy','Wagwoord volg nie wagwoordbeleid nie', "Mật khẩu không tuân theo Chính sách mật khẩu", now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MNIMUM_PASSWORD_LENGTH')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','MNIMUM_PASSWORD_LENGTH','Minimum Password Length','Minimum Password Length','Minimum wagwoordlengte', "Độ dài mật khẩu tối thiểu", now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MAXIMUM_PASSWORD_LENGTH')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','MAXIMUM_PASSWORD_LENGTH','Maximum Password Length','Maximum Password Length','Maksimum wagwoordlengte', "Độ dài mật khẩu tối đa", now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MINIMUM_SPECIAL_CHARACTERS_NEEDED')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','MINIMUM_SPECIAL_CHARACTERS_NEEDED','Minimum Special Character(s) Needed','Minimum Special Character(s) Needed','Minimum spesiale karakter (s) benodig', "(Các) ký tự đặc biệt tối thiểu cần thiết", now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MINIMUM_NO_DIGITS_NEEDED')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','MINIMUM_NO_DIGITS_NEEDED','Minimum No. of Digits Needed','Minimum No. of Digits Needed','Minimum aantal syfers benodig', "Số chữ số tối thiểu cần thiết", now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='MINIMUM_CAPITAL_LETTERS')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','MINIMUM_CAPITAL_LETTERS','Minimum Capital Letters','Minimum Capital Letters','Minimum hoofletters', "Chữ viết hoa tối thiểu", 
now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ALLOWABLE_SPECIAL_CHARACTERS')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('PORTAL_SETUP_NEW','ALLOWABLE_SPECIAL_CHARACTERS','Allowable Special Character(s)','Allowable Special Character(s)','Toelaatbare spesiale karakter (s)', "(Các) ký tự đặc biệt được phép", 
now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='HOSTEL' and keyName='INSTRUCTIONS_GUIDELINES_OTHER_LANGUAGE')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('HOSTEL','INSTRUCTIONS_GUIDELINES_OTHER_LANGUAGE','Enter Instructions / Guidelines to be displayed in Other Language:','Enter Instructions / Guidelines to be displayed in Other Language:','Voer die instruksies / riglyne in wat in die ander taal vertoon moet word:', "Nhập Hướng dẫn / Nguyên tắc để được hiển thị bằng Ngôn ngữ Khác:", 
now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='HOSTEL' and keyName='INSTRUCTIONS_GUIDELINES_ENGLISH')) THEN 
INSERT INTO `ui_translation`
(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`, `afriLanguage`, `vietLanguage`, `lastUpdate`,`lastUpdatedBy`)
VALUES
('HOSTEL','INSTRUCTIONS_GUIDELINES_ENGLISH','Enter Instructions / Guidelines to be displayed in English:','Enter Instructions / Guidelines to be displayed in English:','Voer die instruksies / riglyne in om in Engels te vertoon:', "Nhập Hướng dẫn / Nguyên tắc để được hiển thị bằng tiếng Anh:", 
now(),1);
END IF;

END $$
CALL V20210215110024__Insert_UITranslation() $$
DROP PROCEDURE IF EXISTS V20210215110024__Insert_UITranslation $$
DELIMITER ;