DELIMITER $$
DROP PROCEDURE IF EXISTS V20210309183002__Insert_CourseConsoEventReport $$
CREATE PROCEDURE V20210309183002__Insert_CourseConsoEventReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Student Event Assessment Report' )) THEN
INSERT INTO `report_type` (`typeName`) VALUES ('Student Event Assessment Report'); 
END IF;

IF EXISTS (select max(id) from report_type where typeName='Student Event Assessment Report') THEN
set  @event = (select max(id) from report_type where typeName='Student Event Assessment Report');


IF NOT EXISTS (select * from report_template where `templateCode`='COURSE_WISE_CONSOLIDATED_EVENTS_REPORT') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)

VALUES (@event, 'COURSE_WISE_CONSOLIDATED_EVENTS_REPORT', 'Course Wise Consolidated Events Report', 'COURSE_WISE_CONSOLIDATED_EVENTS_REPORT.png', 'FBC_Event_CommonReport_Excel.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'COURSE_WISE_CONSOLIDATED_EVENTS_REPORT.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'COURSE_WISE_CONSOLIDATED_EVENTS_REPORT')) THEN 
set @course = (select max(id) from `report_template` WHERE templateCode = 'COURSE_WISE_CONSOLIDATED_EVENTS_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_SUMMARY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_SUMMARY', 'SUMMARY OF RESULTS INCLUDING WEIGHTED MARK', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_PROGRAM', 'Programme Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_COURSE_CODE', 'Course Code', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_INTAKE_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_INTAKE_YEAR', 'Intake Year', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_SECTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_SECTION', 'Course Section', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_LECTURER_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_LECTURER_NAME', 'Lecturer Name & Surname', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_SRNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_SRNO', 'S.No.', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_STD_SURNAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_STD_SURNAME', 'SURNAME & NAME', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_ID_NUM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_ID_NUM', 'ID NUMBER', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_ABSENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_ABSENT', 'ABSENT', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_TOTAL_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_TOTAL_MARKS', 'TOTAL MARKs', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_TOTAL_WEIGHTED_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_TOTAL_WEIGHTED_MARKS', 'Total Weighted Mark', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_MARK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_MARK', 'Mark', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_WEIGHTED_MARK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_WEIGHTED_MARK', 'Weighted Mark', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_WROTE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_WROTE', 'Wrote:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_PASSED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_PASSED', 'Passed:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_FAILED')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_FAILED', 'Failed:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_PASSED_PERCENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_PASSED_PERCENT', 'Pass %:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_CLASS_AVG')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_CLASS_AVG', 'Class Average:', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @course and keyValue='TRANS_RETENTION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@course, 'TRANS_RETENTION', 'Retention Rate:', '1', now());
END IF;



END IF;
END IF;
END $$
CALL V20210309183002__Insert_CourseConsoEventReport() $$
DROP PROCEDURE IF EXISTS V20210309183002__Insert_CourseConsoEventReport $$
DELIMITER ;

