DELIMITER $$
DROP PROCEDURE IF EXISTS V20210510165729__Insert_HostelWLTCSM $$
CREATE PROCEDURE V20210510165729__Insert_HostelWLTCSM()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'HOSTEL_WAITING_LIST_TYPE')) THEN 
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'hostel_waiting_list_type_csm','HOSTEL_WAITING_LIST_TYPE','Hostel','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF; 

IF  EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 
SET @standardMasterId=(select id from standard_master where tableName = 'hostel_waiting_list_type_csm');
INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemCode','ITEM_CODE',@standardMasterId,'Varchar',NULL,1,0,NULL,NULL,NULL,0,0,false,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('itemValue','ITEM_VALUE',@standardMasterId,'Varchar',NULL,2,0,NULL,NULL,NULL,0,0,false,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('startDate','START_DATE',@standardMasterId,'Date',NULL,3,0,NULL,NULL,NULL,0,0,true,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('endDate','END_DATE',@standardMasterId,'Date',NULL,4,0,NULL,NULL,NULL,0,0,true,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('studentPortal','STUDENT_PORTAL',@standardMasterId,'Boolean',NULL,5,0,NULL,NULL,NULL,0,0,true,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('applicantPortal','APPLICANT_PORTAL',@standardMasterId,'Boolean',NULL,6,0,NULL,NULL,NULL,0,0,true,NULL,NULL,NULL,1,now());

INSERT INTO `standard_master_items` (`dbFieldName`,`fieldLabel`,`standardMasterId`,`fieldType`,`emunType`,`diaplayOrder`,`whetherForeignKey`,`fkTable`,`fkFieldName`,`fkDisplayField`,`whetherShortCode`,`whetherReadOnly`,`wheherNullable`,`validationType`,`maxLength`,`minLength`,`lastUpdatedBy`,`lastUpdate`)
VALUES ('coreErp','CORE_ERP',@standardMasterId,'Boolean',NULL,7,0,NULL,NULL,NULL,0,0,true,NULL,NULL,NULL,1,now());

END IF; 

-- translations

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'HOSTEL_WAITING_LIST_TYPE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('masterNames', 'HOSTEL_WAITING_LIST_TYPE', 'Hostel Waiting List Type', 'Hostel Waiting List Type',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'START_DATE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'START_DATE', 'Start Date', 'Start Date',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'END_DATE')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'END_DATE', 'End Date', 'End Date',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'STUDENT_PORTAL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'STUDENT_PORTAL', 'Student Portal', 'Student Portal',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'APPLICANT_PORTAL')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'APPLICANT_PORTAL', 'Applicant Portal', 'Applicant Portal',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'CORE_ERP')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'CORE_ERP', 'Core ERP', 'Core ERP',now(),1);
END IF;


END $$
CALL V20210510165729__Insert_HostelWLTCSM() $$
DROP PROCEDURE IF EXISTS V20210510165729__Insert_HostelWLTCSM $$
DELIMITER ;