DELIMITER $$
DROP PROCEDURE IF EXISTS V20210625160550__Create_campaign_details_view $$
CREATE PROCEDURE V20210625160550__Create_campaign_details_view()
BEGIN
DROP VIEW IF EXISTS campaign_details_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='campaign_details_view')) THEN 
create view campaign_details_view AS
SELECT 
        `campacad`.`academyLocationId` AS `academyLocationId`,
        `al`.`academyName` AS `academyName`,
        `al`.`academyCode` AS `academyCode`,
        `al`.`locationName` AS `locationName`,
        `al`.`locationCode` AS `locationCode`,
        `al`.`displayName` AS `academy_location_name`,
        `ir`.`itemValue` AS `intake_year`,
        `campnew`.`modeofDelivery` AS `modeofDelivery`,
        `campnew`.`registrationType` AS `registrationType`,
        `campnew`.`campaignType` AS `campaignType`,
        `campnew`.`presentationType` AS `presentation_medium_type`,
        `campnew`.`presentationSubType` AS `Presentation_Sub_Type`,
        `campnew`.`campaignName` AS `campaignName`,
        `campnew`.`status` AS `status`,
        `usr`.`printName` AS `Owner`,
        `campnew`.`createdOn` AS `createdOn`,
        `campnew`.`startDate` AS `startDate`,
        `campnew`.`endDate` AS `Till_Date`,
        `campnew`.`numberOfleadsTargeted` AS `numberOfleadsTargeted`,
         `campnew`.`id` as `campaignId`,
        (select count(`e`.`id`) from `enquiry` `e` where `e`.`campaignNewId`=`campnew`.`id`) AS `Number_of_Leads_Captured`,
        (select count(`app`.`id`) from `application` `app` inner join `enq_student_details` `esd` on `app`.`enquiryStudentDetailId`=`esd`.`id` inner join `enquiry` `en` on `en`.`id`=`esd`.`enquiryId` where `en`.`campaignNewId`=`campnew`.`id`) as `application_count`,
        (select count(`sapp`.`id`) from `sg_appointment` `sapp` inner join `enquiry` `en` on `en`.`id`=`sapp`.`enquiryId` where `en`.`campaignNewId`=`campnew`.`id`) as `appointment_count`,
        `campsc`.`itemValue` AS `School`,
        `cspm`.`schoolPriority` AS `schoolPriority`
       
    FROM
        ((((((((`campaign_new` `campnew`
        LEFT JOIN `users` `usr` ON ((`campnew`.`ownerId` = `usr`.`id`)))
        LEFT JOIN `intake_year` `ir` ON ((`ir`.`id` = `campnew`.`intakeYearId`)))
        LEFT JOIN `campaign_academy_location` `campacad` ON ((`campacad`.`campaignNewId` = `campnew`.`id`)))
        LEFT JOIN `academy_location` `al` ON ((`al`.`id` = `campacad`.`academyLocationId`))))
        LEFT JOIN `campaign_school_mapping` `campscmp` ON ((`campscmp`.`campaignNewId` = `campnew`.`id`)))
        LEFT JOIN `campaign_school` `campsc` ON ((`campsc`.`id` = `campscmp`.`campaignSchoolId`)))
        LEFT JOIN `campaign_school_priority_mapping` `cspm` ON ((`cspm`.`campaignSchoolId` = `campsc`.`id`)))
    GROUP BY `campnew`.`id` , `campsc`.`id` , `al`.`id`;
END IF; 

END $$
CALL V20210625160550__Create_campaign_details_view () $$ 
DROP PROCEDURE IF EXISTS V20210625160550__Create_campaign_details_view $$ 
DELIMITER ;