DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708165122__Create_Person_view $$
CREATE PROCEDURE V20210708165122__Create_Person_view()
BEGIN

DROP VIEW IF EXISTS person_view;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='person_view')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `person_view` AS
    SELECT DISTINCT
        `appl`.`code` AS `code`,
        `per`.`externalSysRefOne` AS `suNumber`,
        `nat`.`itemValue` AS `nationality`,
        `per`.`lastName` AS `lastName`,
        `per`.`birthDate` AS `dateOfBirth`,
        `per`.`firstName` AS `firstName`,
        `per`.`printName` AS `preferredName`,
        `per`.`nationalID` AS `identificationNumber`,
        `gen`.`itemValue` AS `gender`,
        `cc`.`itemCode` AS `racecode`,
        `cc`.`itemValue` AS `race`,
        `per`.`emailId` AS `emailAddress`,
        `per`.`mobileNumber` AS `mobilenumber`,
        `dd`.`name` AS `homeLanguagecode`,
        `dd`.`value` AS `homeLanguage`,
        `sal`.`salutationName` AS `title`
    FROM
        (((((((`applicant_person` `per`
        LEFT JOIN `nationalities` `nat` ON ((`nat`.`id` = `per`.`nationalityId`)))
        LEFT JOIN `identity_detail` `ide` ON ((`ide`.`personId` = `per`.`id`)))
        LEFT JOIN `gender` `gen` ON ((`per`.`genderId` = `gen`.`id`)))
        JOIN `salutations` `sal` ON ((`sal`.`id` = `per`.`salutationId`)))
        LEFT JOIN `caste_categories` `cc` ON ((`cc`.`id` = `per`.`casteCategoryId`)))
        LEFT JOIN `application` `appl` ON ((`appl`.`applicantPersonId` = `per`.`id`)))
        LEFT JOIN `drop_down` `dd` ON ((`dd`.`id` = `per`.`homeLanguage`)));

END IF; 

END $$
CALL V20210708165122__Create_Person_view () $$ 
DROP PROCEDURE IF EXISTS V20210708165122__Create_Person_view $$ 
DELIMITER ;