DELIMITER $$
DROP PROCEDURE IF EXISTS V20210729143707__Insert_reportTemplate $$
CREATE PROCEDURE V20210729143707__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((select * from report_template where reportTypeId=5 and templateCode='MASTER_TIME_TABLE_CODE_ROOM_WISE')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('5', 'MASTER_TIME_TABLE_CODE_ROOM_WISE', 'Master Timetable Room Wise', 'MASTER_TIME_TABLE_CODE_ROOM_WISE.png', 'CommonReport_MasterTimeTableExcel.jasper', 'All', '0', 'Header_Excel.jasper', 'Footer_Excel.jasper', '0', '0', 'MASTER_TIME_TABLE_CODE_ROOM_WISE.jasper', 'AcademiaLogo.jpg');

END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE reportTemplateId = (select id from report_template where templateCode ='MASTER_TIME_TABLE_CODE_ROOM_WISE') )) THEN
  
set @masterTimeTablePDF = (select id from report_template where templateCode ='MASTER_TIME_TABLE_CODE_ROOM_WISE');
	
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES 	(@masterTimeTablePDF, 'TRANS_TIMETABLE', 'Master Timetable Room Wise', '1',now()),
				(@masterTimeTablePDF, 'TRANS_ROOM', 'Room', '1', now()),
				(@masterTimeTablePDF, 'TRANS_DAY', 'Day/Session', '1', now()),
				(@masterTimeTablePDF, 'TRANS_SESSION', 'Session', '1',now());
	
END IF;

END $$
CALL V20210729143707__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20210729143707__Insert_reportTemplate $$
DELIMITER ;