DELIMITER $$
DROP PROCEDURE IF EXISTS V20210806120545__Create_Fee_Quotation_Documents $$
CREATE PROCEDURE V20210806120545__Create_Fee_Quotation_Documents()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='fee_quotation_documents')) THEN 
CREATE TABLE `fee_quotation_documents` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `documentId` BIGINT NOT NULL,
  `quotationId` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_fee_quotation_documents_to_documents_idx` (`documentId`),
  INDEX `fk_fee_quotation_documents_to_fee_quotation_idx` (`quotationId`),
  INDEX `fk_fee_quotation_documents_to_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_fee_quotation_documents_to_documents_idx`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_fee_quotation_documents_to_fee_quotation_idx`
    FOREIGN KEY (`quotationId`)
    REFERENCES `fee_quotation_details` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_fee_quotation_documents_to_user_idx`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20210806120545__Create_Fee_Quotation_Documents () $$ 
DROP PROCEDURE IF EXISTS V20210806120545__Create_Fee_Quotation_Documents $$ 
DELIMITER ;