drop view if exists `STASY_BILLING_View`;
drop view if exists `Invoice_Header_View`;
drop view if exists `InvoiceHeaderView`;
drop view if exists `STASY_CREDIT_NOTE_View`;
drop view if exists `Invoice_Allocations_View`;
drop view if exists `InvoiceAllocationsView`;
drop view if exists `STASY_BILLING_FEE_HEAD_View`;
drop view if exists `Invoice_Lines_View`;
drop view if exists `InvoiceLineView`;

CREATE VIEW InvoiceHeaderView AS
    SELECT 
        bh.id AS Id,
        CONCAT(bh.billingDate, ' 00:00:00') AS CreationDate,
        u.code AS StudentId,
        bh.raiseBillCategory AS InvoiceType,
        bh.billNo AS InvoiceNumber,
        bh.billingDate AS BillingDate,
        CASE
            WHEN al.terminology = 'COLLEGE' THEN 'TER'
            ELSE 'SCH'
        END AS Division,
        al.academyCode AS BrandCode,
        al.locationCode AS CampusCode,
        CASE
            WHEN
                al.terminology = 'COLLEGE'
            THEN
                (SELECT 
                        pc.categoryName
                    FROM
                        bill_header bhInner
                            LEFT OUTER JOIN
                        prog_batch_seat_config pbscInner ON pbscInner.id = bhInner.programBatchSeatConfigId
                            LEFT OUTER JOIN
                        batches bInner ON bInner.id = pbscInner.programBatchId
                            LEFT OUTER JOIN
                        programs p ON p.id = bInner.programId
                            LEFT OUTER JOIN
                        program_category pc ON pc.id = p.programCategoryId
                    WHERE
                        bhInner.id = bh.id
                            AND bhInner.studentId IS NOT NULL
                    GROUP BY bhInner.id)
            ELSE (SELECT 
                    pg.groupName
                FROM
                    bill_header bhInner
                        LEFT OUTER JOIN
                    prog_batch_seat_config pbscInner ON pbscInner.id = bhInner.programBatchSeatConfigId
                        LEFT OUTER JOIN
                    batches bInner ON bInner.id = pbscInner.programBatchId
                        LEFT OUTER JOIN
                    programs p ON p.id = bInner.programId
                        LEFT OUTER JOIN
                    program_group pg ON pg.id = p.programGroupId
                WHERE
                    bhInner.id = bh.id
                        AND bhInner.studentId IS NOT NULL
                GROUP BY bhInner.id)
        END AS SchoolPhaseFaculty,
        p.programCode AS GradeQualificationCode,
        b.printName AS ClassQualificationIntake,
        bh.reasonForManualBill AS Reason,
        c.currencyCode AS Currency,
        CASE
            WHEN bh.raiseBillCategory = 'BILL_PAYABLE' THEN 0 - SUM(bfprs.billableAmount)
            WHEN bh.raiseBillCategory = 'BILL_RECEIVABLE' THEN SUM(bfprs.billableAmount)
            ELSE NULL
        END AS Amount,
        bh.raiseBillType AS BillType,
        bh.billGenerationType AS BillGenerationType
    FROM
        bill_header bh
            LEFT OUTER JOIN
        prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
            LEFT OUTER JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT OUTER JOIN
        programs p ON p.id = b.programId
            LEFT OUTER JOIN
        academy_location al ON al.id = bh.academyLocationId
            LEFT OUTER JOIN
        bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
            LEFT OUTER JOIN
        users u ON u.id = bh.studentId
            LEFT OUTER JOIN
        currency c ON c.id = bh.currencyId
            LEFT OUTER JOIN
        fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
            LEFT OUTER JOIN
        fee_heads fh ON fh.id = fshc.feeHeadId
            LEFT OUTER JOIN
        fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
            LEFT OUTER JOIN
        fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
            LEFT OUTER JOIN
        fee_plan fp ON fp.id = fpr.feePlanId
            LEFT OUTER JOIN
        fee_plan_persons_covered fppc ON fppc.feePlanRuleId = fpr.id
            AND bh.studentId = fppc.studentId
    WHERE
        bh.studentId IS NOT NULL
    GROUP BY bh.id 
    UNION SELECT 
        bh.id AS Id,
        CONCAT(bh.billingDate, ' 00:00:00') AS CreationDate,
        u.code AS StudentId,
        bh.raiseBillCategory AS InvoiceType,
        bh.billNo AS InvoiceNumber,
        bh.billingDate AS BillingDate,
        CASE
            WHEN al.terminology = 'COLLEGE' THEN 'TER'
            ELSE 'SCH'
        END AS Division,
        al.academyCode AS BrandCode,
        al.locationCode AS CampusCode,
        CASE
            WHEN
                al.terminology = 'COLLEGE'
            THEN
                (SELECT 
                        pc.categoryName
                    FROM
                        bill_header bhInner
                            LEFT OUTER JOIN
                        prog_batch_seat_config pbscInner ON pbscInner.id = bhInner.programBatchSeatConfigId
                            LEFT OUTER JOIN
                        batches bInner ON bInner.id = pbscInner.programBatchId
                            LEFT OUTER JOIN
                        programs p ON p.id = bInner.programId
                            LEFT OUTER JOIN
                        program_category pc ON pc.id = p.programCategoryId
                    WHERE
                        bhInner.id = bh.id
                            AND bhInner.studentId IS NOT NULL
                    GROUP BY bhInner.id)
            ELSE (SELECT 
                    pg.groupName
                FROM
                    bill_header bhInner
                        LEFT OUTER JOIN
                    prog_batch_seat_config pbscInner ON pbscInner.id = bhInner.programBatchSeatConfigId
                        LEFT OUTER JOIN
                    batches bInner ON bInner.id = pbscInner.programBatchId
                        LEFT OUTER JOIN
                    programs p ON p.id = bInner.programId
                        LEFT OUTER JOIN
                    program_group pg ON pg.id = p.programGroupId
                WHERE
                    bhInner.id = bh.id
                        AND bhInner.studentId IS NOT NULL
                GROUP BY bhInner.id)
        END AS SchoolPhaseFaculty,
        p.programCode AS GradeQualificationCode,
        b.printName AS ClassQualificationIntake,
        bh.reasonForManualBill AS Reason,
        c.currencyCode AS Currency,
        CASE
            WHEN bh.raiseBillCategory = 'BILL_PAYABLE' THEN SUM(bfprs.billableAmount)
            WHEN bh.raiseBillCategory = 'BILL_RECEIVABLE' THEN 0 - SUM(bfprs.billableAmount)
            ELSE NULL
        END AS Amount,
        bh.raiseBillType AS BillType,
        bh.billGenerationType AS BillGenerationType
    FROM
        bill_header bh
            LEFT OUTER JOIN
        prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
            LEFT OUTER JOIN
        batches b ON b.id = pbsc.programBatchId
            LEFT OUTER JOIN
        programs p ON p.id = b.programId
            LEFT OUTER JOIN
        academy_location al ON al.id = bh.academyLocationId
            LEFT OUTER JOIN
        bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
            LEFT OUTER JOIN
        users u ON u.id = bh.studentId
            LEFT OUTER JOIN
        currency c ON c.id = bh.currencyId
            LEFT OUTER JOIN
        fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
            LEFT OUTER JOIN
        fee_heads fh ON fh.id = fshc.feeHeadId
            LEFT OUTER JOIN
        fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
            LEFT OUTER JOIN
        fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
            LEFT OUTER JOIN
        fee_plan fp ON fp.id = fpr.feePlanId
            LEFT OUTER JOIN
        fee_plan_persons_covered fppc ON fppc.feePlanRuleId = fpr.id
            AND bh.studentId = fppc.studentId
    WHERE
        bh.billStatus = 'CANCELLED'
            AND bh.studentId IS NOT NULL
    GROUP BY bh.id;
	

CREATE VIEW InvoiceAllocationsView AS
SELECT 
    cn.id AS BillId,
    cn.billNo AS InvoiceNumber,
    bh.billNo AS ApplyToInvoiceNumber
FROM
    bill_header cn
        LEFT OUTER JOIN
        bill_header bh ON bh.id=cn.billHeaderForDiscountBillId
WHERE
    cn.billStatus <> 'CANCELLED'
    AND cn.billHeaderForDiscountBillId is not Null
GROUP BY cn.id;


CREATE VIEW InvoiceLineView AS
SELECT 
    bh.id AS BillId,
	bh.billNo AS InvoiceNumber,
    bh.dueDate AS BillingDueDate,
    fppc.joinDate AS BillingStartDate,
    CASE
        WHEN al.terminology = 'COLLEGE'
        THEN  b.tillDate
        ELSE  CONCAT('31-12-',IY.itemCode)
    END AS BillingEndDate,
    fh.feeHeadName AS FeeHeadName,
    fp.feePlanId AS FeePlanId,
    fp.feePlanName AS FeePlanName,
    fshc.remark AS PaymentSchedule,
    fpr.feeRuleDesc AS FeePlanRuleDescription,
    c.currencyCode AS Currency,
    CASE
        WHEN
            bh.raiseBillCategory = 'BILL_PAYABLE'
			THEN 0 - bfprs.billableAmount
        WHEN
            bh.raiseBillCategory = 'BILL_RECEIVABLE'
			THEN bfprs.billableAmount
        ELSE NULL
    END AS Amount,
    bh.raiseBillType AS BillType
FROM
    bill_fee_plan_rule_stage bfprs
        LEFT OUTER JOIN
    bill_header bh ON bh.id = bfprs.billId
        LEFT OUTER JOIN
    prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
        LEFT OUTER JOIN
    batches b ON b.id = pbsc.programBatchId
    LEFT OUTER JOIN
    intake_year IY ON IY.id=b.intakeYearId
        LEFT OUTER JOIN
    academy_location al ON al.id = bh.academyLocationId
        LEFT OUTER JOIN
    users u ON u.id = bh.studentId
        LEFT OUTER JOIN
    currency c ON c.id = bh.currencyId
        LEFT OUTER JOIN
    fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
        LEFT OUTER JOIN
    fee_heads fh ON fh.id = fshc.feeHeadId
        LEFT OUTER JOIN
    fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
        LEFT OUTER JOIN
    fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
        LEFT OUTER JOIN
    fee_plan fp ON fp.id = fpr.feePlanId
        LEFT OUTER JOIN
    fee_plan_persons_covered fppc ON fppc.feePlanRuleId = fpr.id
        AND bh.studentId = fppc.studentId
WHERE
		bh.studentId IS NOT NULL
GROUP BY bfprs.id
UNION
SELECT 
    bh.id AS BillId,
	bh.billNo AS InvoiceNumber,
    bh.dueDate AS BillingDueDate,
    fppc.joinDate AS BillingStartDate,
    CASE
        WHEN al.terminology = 'COLLEGE'
        THEN  b.tillDate
        ELSE  CONCAT('31-12-',IY.itemCode)
    END AS BillingEndDate,
    fh.feeHeadName AS FeeHeadName,
    fp.feePlanId AS FeePlanId,
    fp.feePlanName AS FeePlanName,
    fshc.remark AS PaymentSchedule,
    fpr.feeRuleDesc AS FeePlanRuleDescription,
    c.currencyCode AS Currency,
    CASE
        WHEN
            bh.raiseBillCategory = 'BILL_PAYABLE'
			THEN bfprs.billableAmount
        WHEN
            bh.raiseBillCategory = 'BILL_RECEIVABLE'
			THEN 0 - bfprs.billableAmount
        ELSE NULL
    END AS Amount,
    bh.raiseBillType AS BillType
FROM
    bill_fee_plan_rule_stage bfprs
        LEFT OUTER JOIN
    bill_header bh ON bh.id = bfprs.billId
        LEFT OUTER JOIN
    prog_batch_seat_config pbsc ON pbsc.id = bh.programBatchSeatConfigId
        LEFT OUTER JOIN
    batches b ON b.id = pbsc.programBatchId
    LEFT OUTER JOIN
    intake_year IY ON IY.id=b.intakeYearId
        LEFT OUTER JOIN
    academy_location al ON al.id = bh.academyLocationId
        LEFT OUTER JOIN
    users u ON u.id = bh.studentId
        LEFT OUTER JOIN
    currency c ON c.id = bh.currencyId
        LEFT OUTER JOIN
    fee_stage_head_config fshc ON fshc.id = bfprs.feeStageHeadConfigId
        LEFT OUTER JOIN
    fee_heads fh ON fh.id = fshc.feeHeadId
        LEFT OUTER JOIN
    fee_plan_rule_stage fprs ON fprs.id = fshc.feePlanRuleStageId
        LEFT OUTER JOIN
    fee_plan_rules fpr ON fpr.id = fprs.feePlanRuleId
        LEFT OUTER JOIN
    fee_plan fp ON fp.id = fpr.feePlanId
        LEFT OUTER JOIN
    fee_plan_persons_covered fppc ON fppc.feePlanRuleId = fpr.id
        AND bh.studentId = fppc.studentId
WHERE
		bh.billStatus='CANCELLED'
		AND bh.studentId IS NOT NULL
GROUP BY bfprs.id;