DELIMITER $$
DROP PROCEDURE IF EXISTS V20211017222601__Insert_reportTemplate $$
CREATE PROCEDURE V20211017222601__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SAMHS_TRANSCRIPT_EXCEL')) THEN 
set @transID = (select id from report_type WHERE typeName = 'Mark Sheet');
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`,`templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@transID, 'SAMHS_TRANSCRIPT_EXCEL', 'SAMHS Transcript_Excel', 'SAMHS_TRANSCRIPT_EXCEL.png','CommonReport_Excel_SAMHS.jasper','EVALUATION_PLAN',  'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'SAMHS_TRANSCRIPT_EXCEL.jasper', 'AcademiaLogo.png');
END IF;

IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SAMHS_TRANSCRIPT_EXCEL')) THEN 

set @reportTempId = (select max(id) from report_template where templateCode='SAMHS_TRANSCRIPT_EXCEL');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTempId, 'TRANS_QUALIFICATION', 'QUALIFICATION:', '1', now()),
(@reportTempId, 'TRANS_DETAILS', '1. DETAILS OF THE NURSING EDUCATION INSTITUTION', '1', now()),
(@reportTempId, 'TRANS_NAME', 'Name', '1', now()),
(@reportTempId, 'TRANS_CORRESPONDENCE', 'Correspondence No', '1', now()),
(@reportTempId, 'TRANS_FULL_ADDRESS', 'Full Address', '1', now()),
(@reportTempId, 'TRANS_TELEPHONE', 'Telephone No', '1', now()),
(@reportTempId, 'TRANS_FAX', 'Fax No', '1', now()),
(@reportTempId, 'TRANS_EMAIL', 'E-mail Address', '1', now()),

(@reportTempId, 'TRANS_DETAILS2', '2. DETAILS OF PERSON IN CHARGE OF NURSING EDUCATION', '1', now()),
(@reportTempId, 'TRANS_NAME2', 'Name', '1', now()),
(@reportTempId, 'TRANS_SANC', 'SANC Reference No', '1', now()),
(@reportTempId, 'TRANS_PROFESSIONAL_QUALI', 'Professional Qualifications', '1', now()),

(@reportTempId, 'TRANS_SAQA_ID', '3. SAQA ID OF THE ACCREDITED PROGRAMME', '1', now()),

(@reportTempId, 'TRANS_STUDENTS_DETAILS', '4. STUDENT DETAILS', '1', now()),
(@reportTempId, 'TRANS_STD_F_NAME', 'Student Full name', '1', now()),
(@reportTempId, 'TRANS_SANC_NO', 'SANC Number', '1', now()),
(@reportTempId, 'TRANS_ID_NO', 'ID Number', '1', now()),
(@reportTempId, 'TRANS_DATE', 'Date of Commencement', '1', now()),
(@reportTempId, 'TRANS_COMPLETION_DATE', 'Date of Completion', '1', now()),
(@reportTempId, 'TRANS_FOR_OFFICE1', 'For office use', '1', now()),

(@reportTempId, 'TRANS_RECORDS', '5.1 RECORD OF EDUCATION AND TRAINING (THEORY)', '1', now()),
(@reportTempId, 'TRANS_EXIT', 'EXIT LEVEL OUTCOMES', '1', now()),
(@reportTempId, 'TRANS_MODULES', 'Modules', '1', now()),
(@reportTempId, 'TRANS_CREDITS', 'Prescribed Credits', '1', now()),
(@reportTempId, 'TRANS_ACHIEVED', 'Achieved by Student (hours) Attendance part', '1', now()),
(@reportTempId, 'TRANS_FOR_OFFICE2', 'For office use', '1', now()),
(@reportTempId, 'TRANS_TOTAL', 'Total', '1', now()),

(@reportTempId, 'TRANS_INTEGRATED', '5.2 WORK INTEGRATED LEARNING/EXPERIENTIAL LEARNING', '1', now()),
(@reportTempId, 'TRANS_PRACTICE', 'Area of Practice', '1', now()),
(@reportTempId, 'TRANS_PRES_CREDITS', 'Prescribed Credits', '1', now()),
(@reportTempId, 'TRANS_ACHIEVED_STD', 'Achieved by Student', '1', now()),
(@reportTempId, 'TRANS_FOR_OFFICE3', 'For office use', '1', now()),
(@reportTempId, 'TRANS_TOTAL1', 'Total', '1', now()),

(@reportTempId, 'TRANS_SUMMATIVE', '5.3 SUMMATIVE ASSESSMENT OUTCOMES', '1', now()),
(@reportTempId, 'TRANS_SUBJECT', 'Subject / module / study unit', '1', now()),
(@reportTempId, 'TRANS_ASSESSMENT', 'Assessment Outcome', '1', now()),
(@reportTempId, 'TRANS_FOR_OFFICE4', 'For office use', '1', now()),

(@reportTempId, 'TRANS_KEYS', 'Keys for Modules', '1', now()),

(@reportTempId, 'TRANS_APPROVED', '5.4 APPROVED/ACCREDITED CLINICAL FACILITIES USED FOR  PLACEMENT', '1', now()),
(@reportTempId, 'TRANS_FOR_OFFICE5', 'For office use', '1', now()),

(@reportTempId, 'TRANS_LEAVE', '5.5 LEAVE', '1', now()),
(@reportTempId, 'TRANS_LEAVE_TYPE', 'Type of Leave', '1', now()),
(@reportTempId, 'TRANS_FROM', 'From', '1', now()),
(@reportTempId, 'TRANS_TO', 'To', '1', now()),
(@reportTempId, 'TRANS_DAYS', 'Days', '1', now()),
(@reportTempId, 'TRANS_FOR_OFFICE6', 'For office use', '1', now());

END IF;

END $$
CALL V20211017222601__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20211017222601__Insert_reportTemplate $$
DELIMITER ;

