DELIMITER $$
DROP PROCEDURE IF EXISTS V20211117115315__Create_AreaOfInterestCSM $$
CREATE PROCEDURE V20211117115315__Create_AreaOfInterestCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='area_of_interest')) THEN 
CREATE TABLE area_of_interest (
    id BIGINT(20) NOT NULL AUTO_INCREMENT, 
    itemCode varchar(100) NOT NULL,
    itemValue varchar(100) NOT NULL,
    itemNameinOtherLanguage varchar(100) NULL,
    lastUpdatedBy BIGINT(20) NOT NULL,
    lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (id)
    );
 
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'area_of_interest','AREA_OF_INTEREST','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'ITEM_NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'itemNameinOtherLanguage', 'ITEM_NAME_OTHER_LANG', @standardMasterMaxId+1, 'varchar', '3', 0, 0, 0, 1, '1', SYSDATE());
    
END IF; 

END $$
CALL V20211117115315__Create_AreaOfInterestCSM () $$ 
DROP PROCEDURE IF EXISTS V20211117115315__Create_AreaOfInterestCSM $$ 
DELIMITER ;