DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_persondetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_persondetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN

select 
case when char_length(per.nationalId)=13 then per.nationalID else null end as National_Id,
case when (char_length(per.nationalId)>0 && char_length(per.nationalId)<>13) then per.nationalID 
when usr.code is null then usr1.code else usr.code end as Person_Alternate_Id,
case 
when (char_length(per.nationalId)>0 && char_length(per.nationalId)<>13) then 527
when iddetail.idNumber is not null then iddetail.itemCode  
when stf.userid is not null then 539
when stf.userid is null and usr.id is not null then 537 end as Alternate_Id_Type_Id,
case when castc.itemCode = 'Black' then 'BC'
when castc.itemCode = 'Mixed' then 'U'
when castc.itemCode = 'Person not prepared to say' then 'U'
when castc.itemCode ='' then 'U' 
when castc.itemCode is null then 'U' else castc.itemCode end as Equity_Code,
case when per.isLearnerSACitizen=1 then 'SA' else 'U' end as Nationality_Code,
case when dropd.name  ='' then 'Eng' when
 dropd.name is null then 'Eng' else dropd.name end as Home_Language_Code,
 case when gen.id not in (1,2) then 'M' else gen.itemCode end as Gender_Code,
case when substr(per.nationalID,11,1) = '0' then 'SA' when substr(per.nationalID,11,1)='1' then 'PR' else 'U' end as Citizen_Resident_Status_Code,
'' as Filler01,
case when dropdisable.name is null then 'N' else dropdisable.name end as Disability_Status_Code,
case when per.lastName is null or per.lastName in ("U", "NA", "GEEN", "NONE") then "A" else UPPER(per.lastName) end as Person_Last_Name,
UPPER(substring_index(per.firstName,' ',1)) as Person_First_Name,
UPPER(per.middleName) as Person_Middle_Name
,sal.salutationName as Person_Title
,DATE_FORMAT(per.birthDate, '%Y%m%d') as Person_Birth_Date,
addr.addressText as Person_Home_Address_1
,ct1.cityName as Person_Home_Address_2,
cnt1.countryName as Person_Home_Address_3,
addr2.addressText as  Person_Postal_Address_1
,ct2.cityName as Person_Postal_Address_2,
cnt2.countryName as Person_Postal_Address_3,
addr.pincode as Person_Home_Addr_Postal_Code,
addr2.pincode as Person_Postal_Addr_Post_Code,
concat(per.phoneAreaCode,' ',per.phoneNo) as Person_Phone_Number
,per.mobileNumber as Person_Cell_Phone_Number,
'' as Person_Fax_Number
,per.emailId as Person_Email_Address,
case when cr2.code is null then 1 else cr2.code end as Province_Code,
case when al1.locationCode is null then loc.shortCode else al1.locationCode end as Provider_Code,
541 as Provider_ETQE_Id,
case when per.lastName is null or per.lastName in ("U", "NA", "GEEN", "NONE") then "A" else UPPER(per.lastName) end as Person_Previous_Lastname,
case when usr.code is null then usr1.code else usr.code end as Person_Previous_Alternate_Id,
case when iddetail.idNumber is not null then iddetail.itemCode  
when stf.userid is not null then 539
when stf.userid is null and usr.id is not null then 537 end as Person_Previous_Alternate_Id_Type_Id,
case when al1.locationCode is null then loc.shortCode else al1.locationCode end as Person_Previous_Provider_Code,
541 as Person_Previous_Provider_ETQE_Id,
case when dropdown.type is not null and dropdown.type like '%Seeing%' then dropdown.name else 1 end Seeing_Rating_Id,
case when dropdown.type is not null and dropdown.type like '%Hearing%' then dropdown.name else 1 end Hearing_Rating_Id,
case when dropdown.type is not null and dropdown.type like '%Walking%' then dropdown.name else 1 end Walking_Rating_Id,
case when dropdown.type is not null and dropdown.type like '%Remembering%' then dropdown.name else 1 end Remembering_Rating_Id,
case when dropdown.type is not null and dropdown.type like '%Communicating%' then dropdown.name else 1 end Communicating_Rating_Id,
case when dropdown.type is not null and dropdown.type like '%Self Care%' then dropdown.name else 1 end Self_Care_Rating_Id,
case when per.isMilitarySponsored = 1 then 0 else 1 end as POPI_Act_Status_ID,
case when adm.admissionDate is null and stf.joiningDate is null then '20210101'
when adm.admissionDate is null then DATE_FORMAT(stf.joiningDate, '%Y%m%d') else DATE_FORMAT(adm.admissionDate, '%Y%m%d') end as POPI_Act_Status_Date,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
from
persons per left join students stu  on(stu.personId=per.id)
left join users usr on(usr.id=stu.userid and usr.code is not null)
left join admission adm on(adm.studentId=stu.userid and adm.activeStatus = 1)
left join program_batch_students progbatchstu on(progbatchstu.admissionid=adm.id)
left join staffs stf on (stf.personid=per.id)
left join users usr1 on (stf.userid=usr1.id and usr1.code is not null)
left join user_academy_locations ual on(ual.userId=usr.id)
left join user_academy_locations ual1 on (ual1.userid=usr1.id)
left join academy_location al1 on (ual1.academyLocationId=al1.id)
left join academy_location_addresses aladd on(aladd.academyLocationId=ual.academyLocationId)
left join address add1 on(add1.id=aladd.addressId)
left join country_region cr2 on(cr2.id=add1.parentRegionId)
left join drop_down dropdisable on(per.haveDisabilities=dropdisable.id)
left join gender gen on(per.genderid=gen.id)
left join batches batch on(progbatchstu.programBatchId=batch.id and batch.startDate < NOW())
left join programs prog on(batch.programId=prog.id)
left join academy_location al on(al.id=prog.academyLocationId)
left join locations loc on(al.locationId=loc.id)
left join salutations sal on(sal.id=per.salutationId)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION by personId order by isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
left join caste_categories castc on(castc.id=per.castCategoryId)
left join nationalities nation on(nation.id=per.nationalityId)
left join drop_down dropd on(dropd.id=per.homelanguage)
left join person_addresses peradd on(per.id=peradd.personId)
left join (select add1.* from address add1 left join address_type addty1
on(add1.addressTypeId=addty1.id and addty1.addressTypeName='Current' and addty1.addressCategory='PERSON')) addr
on(addr.id=peradd.addressId)
left join city ct1 on(addr.cityId=ct1.id)
left join country cnt1 on(addr.countryId=cnt1.id)
left join (select add1.* from address add1 left join address_type addty1
on(add1.addressTypeId=addty1.id and addty1.addressTypeName='Correspondance' and addty1.addressCategory='PERSON')) addr2
on(addr2.id=peradd.addressId )
left join city ct2 on(addr2.cityId=ct2.id)
left join country cnt2 on(addr2.countryId=cnt2.id)
left join non_academic_achievements nonacad on(nonacad.person_id=per.id)
left join drop_down dropdown on(dropdown.id=nonacad.levelEventId)
left join
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode,iddtla.lastName from(
select idNumber,personId,idt.itemCode,per1.lastName,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')
left join persons per1 on(per1.id=iddet.personId)
) iddtla where iddtla.rn=2) iddetailmin on(per.id=iddetailmin.personId)
where ((adm.activeStatus = 1 and batch.intakeYearId = intakeYearId) or (stf.userid is not null and usr1.code not in ('serotracker','SYSADMIN',
'PUBLIC_PORTAL_USER','APPLICANT_PORTAL_USER','ENQUIRY_PORTAL_USER','SSO_USER','MISAdmin'))) 
and FIND_IN_SET( al.id,p_alid)  or FIND_IN_SET(al1.id,p_alid) and usr1.code not in ('serotracker','SYSADMIN',
'PUBLIC_PORTAL_USER','APPLICANT_PORTAL_USER','ENQUIRY_PORTAL_USER','SSO_USER','MISAdmin') -- and (usr.status=1 or usr1.status=1)
group by usr.code, usr1.code, loc.shortcode;
END//
DELIMITER ;