DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_programdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_programdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN


select distinct
programCode as ProgrammeCode, 
programNameToBePrint as Programme_Description,
case when pph.id is null then 1 else pph.id end as Programme_Type_Id,
case when hl.itemCode is null then 515 else hl.itemCode end as NQF_Level_Id,
case when pcesm.itemCode is null then 530 else pcesm.itemCode end as Subfield_Id,
case when rt.itemCode is null then 1 else rt.itemCode end as AET_Level_Id,
DATE_FORMAT(b.startDate, '%Y%m%d') as Programme_Start_Date,
case when b.tillDate < now() then DATE_FORMAT(b.tillDate, '%Y%m%d') else null end as Programme_End_Date,
 al.locationCode as Provider_Code,
 '541' Provider_ETQE_Id,
 case when b.tillDate < now() THEN 2 ELSE 1 END as Programme_Status_Id,
 40 as Programme_Credit,
 DATE_FORMAT(now(), '%Y%m%d') as Date_Stamp
 from 
programs p 
left join batches b on (b.programId=p.id and b.startDate < now())
 left join academy_location al on al.id=p.academyLocationId
 left join program_group pg  on pg.id=p.programGroupId
 left join program_phase pph on pph.id=p.programPhaseId
 left join program_cesm pcesm on pcesm.id=p.programCESMId
 left join heqf_level hl on hl.id=p.heqfLevelId
 left join registration_type rt on rt.id=p.registrationTypeId
 left join affiliated_university au on au.id=p.affiliatedUniversityId
 where year(now()) between year(b.startDate) and year(b.tillDate) and p.status='O' 
 and b.intakeYearId = intakeYearId and
-- p.educationDepartmentProgramCode is null and
 al.locationCode <> 'FBC'  and FIND_IN_SET( al.id,p_alid)
 group by p.id;

END//
DELIMITER ;