DELIMITER $$
DROP PROCEDURE IF EXISTS V20220503163028__Create_term_wise_registration_rules $$
CREATE PROCEDURE V20220503163028__Create_term_wise_registration_rules()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='term_wise_registration_rules')) THEN 
CREATE TABLE `term_wise_registration_rules` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `termWiseRegistrationId` bigint NOT NULL,
  `registrationRule` varchar(255) NOT NULL,
  `whetherMandatory` bit(1) NOT NULL DEFAULT b'1',
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_registration_rules_idx` (`termWiseRegistrationId`),
  KEY `term_wise_registration_rules_idx_1` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_registration_rules` FOREIGN KEY (`termWiseRegistrationId`) REFERENCES `registration_term_setup_detail` (`id`),
  CONSTRAINT `fk_term_wise_registration_rules_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20220503163028__Create_term_wise_registration_rules () $$ 
DROP PROCEDURE IF EXISTS V20220503163028__Create_term_wise_registration_rules $$ 
DELIMITER ;