DELIMITER $$
DROP PROCEDURE IF EXISTS V20220525130916__Insert_UWC_Invoice $$
CREATE PROCEDURE V20220525130916__Insert_UWC_Invoice()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '3' AND templateCode = 'MANAGE_BILLS_CODE' AND templateName='UWC Invoice')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('3', 'MANAGE_BILLS_CODE', 'UWC Invoice', 'Bill.png', 'CommonReport_Bill.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'UWC_INVOICE.jasper', 'AcademiaLogo.png');


set @reportTempId= (select max(id) from report_template where   templateName='UWC Invoice'  );

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@reportTempId , 'TRANS_TAX_INVOICE', 'TAX INVOICE', '1', NOW()),
(@reportTempId, 'TRANS_Name', 'Name', '1', NOW()),
(@reportTempId, 'TRANS_ADDRESS', 'Address', '1', NOW()),
(@reportTempId, 'TRANS_INVOICE_NUMBER', 'Invoice Number', '1', NOW()),
(@reportTempId, 'TRANS_INVOICE_DATE', 'Invoice Date', '1', NOW()),
(@reportTempId, 'TRANS_STUDENT_NAME', 'Student name', '1', NOW()),
(@reportTempId, 'TRANS_FACULTY', 'Faculty', '1', NOW()),
(@reportTempId, 'TRANS_DEPARTMENT', 'Department', '1', NOW()),
(@reportTempId, 'TRANS_COURSE_NAME', 'Course Name', '1', NOW()),
(@reportTempId, 'TRANS_COURSE_START_DATE', 'Course Start Date', '1', NOW()),
(@reportTempId, 'TRANS_STUDENT_NUMBER', 'Student Number', '1', NOW()),
(@reportTempId, 'TRANS_PARTICULARS', 'Particulars', '1', NOW()),
(@reportTempId, 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@reportTempId, 'TRANS_TOTAL_INVOICE_VALUE', 'Total Invoice Value', '1', NOW()),
(@reportTempId, 'TRANS_NOTE', 'Note', '1', NOW()),
(@reportTempId, 'TRANS_COM_REG_NUM', 'Company Registration Number', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_1', 'point one', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_2', 'point 2', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_3', 'point 3', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_4', 'point 4', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_5', 'point 5', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_6', 'point 6', '1', NOW()),
(@reportTempId, 'TRANS_VAT', 'VAT number', '1', NOW()),
(@reportTempId, 'TRANS_VAT_VAL', 'VAT number value', '1', NOW()),
(@reportTempId, 'TRANS_COM_VAl', 'Company Val', '1', NOW()),
(@reportTempId, 'TRANS_NOTE_POINT_7', 'point 7', '1', NOW());
END IF; 

END $$
CALL V20220525130916__Insert_UWC_Invoice() $$
DROP PROCEDURE IF EXISTS V20220525130916__Insert_UWC_Invoice $$
DELIMITER ;