DELIMITER $$
DROP PROCEDURE IF EXISTS V20220808121956__Create_StudentThesisTitleTable $$
CREATE PROCEDURE V20220808121956__Create_StudentThesisTitleTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_thesis_title')) THEN 
CREATE TABLE `student_thesis_title`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint DEFAULT NULL,
`title` varchar(255) DEFAULT NULL,
`shortSummaryForGraduation` varchar(255) DEFAULT NULL,
`classified` bit(1) DEFAULT NULL,
`approvalBody` bigint(20) DEFAULT NULL,
`approvalStatus` bigint(20) DEFAULT NULL,
`approvalDate` date DEFAULT NULL,
`auditDate` date DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_stdthesistitle_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_stdthesistitle_SU_approvalBody` FOREIGN KEY (`approvalBody`) REFERENCES `thesis_approval_body` (`id`),
CONSTRAINT `FK_stdthesistitle_SU_approvalStatus` FOREIGN KEY (`approvalStatus`) REFERENCES `thesis_approval_status` (`id`),
CONSTRAINT `FK_stdthesistitle_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_stdthesistitle_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20220808121956__Create_StudentThesisTitleTable () $$ 
DROP PROCEDURE IF EXISTS V20220808121956__Create_StudentThesisTitleTable $$ 
DELIMITER ;