DELIMITER $$
DROP PROCEDURE IF EXISTS V20220824153456__Insert_IndusStudentIdCardTemp $$
CREATE PROCEDURE V20220824153456__Insert_IndusStudentIdCardTemp()
BEGIN

IF NOT EXISTS ((select * from report_template where templateCode = 'INDUS_STUDENT_ID_CARD_WIIA')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('7', 'INDUS_STUDENT_ID_CARD_WIIA', 'Indus Student ID Card WIIA', 'INDUS_STUDENT_ID_CARD_WIIA.png', 'CommonReport_IdCard_Indus_WIIA.jasper', NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'INDUS_STUDENT_ID_CARD_WIIA.jasper', 'AcademiaLogo.png');

set @WIIA_StudentIDCardTempId = (select max(id) from report_template where templateCode ='INDUS_STUDENT_ID_CARD_WIIA');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@WIIA_StudentIDCardTempId, 'TRANS_STUDENT_IDENTITY_CARD', 'STUDENT IDENTITY CARD', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_ESTD_2004', 'Estd. 2004', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_APPROVEDBY', 'Approved by DGCA , Govt. of India', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_VALIDITY_FROM', 'Validity From', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_PERMANENT_ADDRESS', 'PERMANENT ADDRESS', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_EMERGENCY_CONTACT', 'EMERGENCY CONTACT', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_DATE_OF_BIRTH', 'DATE OF BIRTH', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_BLOOD_GROUP', 'BLOOD GROUP', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_INSTRUCTION', 'INSTRUCTION', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_FIRST_INSTRUCTION', 'This card is the property of WIIA,', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_SECOND_INSTRUCTION', 'Ahmedabad and is not transferable. Finder may', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_THIRD_INSTRUCTION', 'mail it to the institute address given on the card.', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_PHONE', 'Phone', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_EMAIL', 'E-mail', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_ISSUING_AUTHORITY', 'Issuing Authority', '1', NOW()),
(@WIIA_StudentIDCardTempId, 'TRANS_WEBSITE', 'Website', '1', NOW());

END IF; 

END $$
CALL V20220824153456__Insert_IndusStudentIdCardTemp() $$
DROP PROCEDURE IF EXISTS V20220824153456__Insert_IndusStudentIdCardTemp $$
DELIMITER ;