DELIMITER $$
DROP PROCEDURE IF EXISTS V20220826150035__Alter_CreditFeeMappingAddColumns $$
CREATE PROCEDURE V20220826150035__Alter_CreditFeeMappingAddColumns()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='credit_fee_mapping' AND COLUMN_NAME='paymentGroupId')) THEN 
ALTER TABLE `credit_fee_mapping` 
ADD COLUMN `paymentGroupId` BIGINT NULL DEFAULT NULL AFTER `amountPerCredit`,
ADD CONSTRAINT `fk_credit_fee_mapping_paymentGroup` FOREIGN KEY (`paymentGroupId`) REFERENCES `payment_group` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='credit_fee_mapping' AND COLUMN_NAME='paymentTermId')) THEN 
ALTER TABLE `credit_fee_mapping` 
ADD COLUMN `paymentTermId` BIGINT NULL DEFAULT NULL AFTER `paymentGroupId`,
ADD CONSTRAINT `fk_credit_fee_mapping_paymentTerm` FOREIGN KEY (`paymentTermId`) REFERENCES `payment_term` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='credit_fee_mapping' AND column_name='courseType')) THEN 
ALTER TABLE `credit_fee_mapping`
ADD COLUMN `courseType` VARCHAR(255) DEFAULT NULL  AFTER `paymentTermId`;
END IF; 

END $$
CALL V20220826150035__Alter_CreditFeeMappingAddColumns() $$
DROP PROCEDURE IF EXISTS V20220826150035__Alter_CreditFeeMappingAddColumns $$
DELIMITER ;