DELIMITER $$
DROP PROCEDURE IF EXISTS V20220922202852__Alter_AddNewColsToScholarship $$
CREATE PROCEDURE V20220922202852__Alter_AddNewColsToScholarship()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='fundType')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `fundType` varchar(25) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='scholarshipNameOtherLanguage')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `scholarshipNameOtherLanguage` varchar(255) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='scholarshipValidFrom')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `scholarshipValidFrom` DATE NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='scholarshipValidTill')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `scholarshipValidTill` DATE NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='graduateLevel')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `graduateLevel` varchar(15) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='costCentreId')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `costCentreId` BIGINT(20) NULL DEFAULT NULL,
ADD CONSTRAINT `fk_scholarship_costCentreId` FOREIGN KEY (`costCentreId`) REFERENCES `cost_centre` (`id`);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='applicationRequired')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `applicationRequired` bit(1) NULL DEFAULT b'1';
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='applicationStartDate')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `applicationStartDate` DATE NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='applicationEndDate')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `applicationEndDate` DATE NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='maxAmountPerStudent')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `maxAmountPerStudent` BIGINT(10) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='budgetAmount')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `budgetAmount` BIGINT(10) NULL DEFAULT NULL;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='darScholarship')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `darScholarship` bit(1) NULL DEFAULT b'0';
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='allowApplicationAfterEndDate')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `allowApplicationAfterEndDate` bit(1) NULL DEFAULT b'0';
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='coversOldDebt')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `coversOldDebt` bit(1) NULL DEFAULT b'1';
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='allocateBalanceOn')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `allocateBalanceOn` bit(1) NULL DEFAULT b'0';
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='purpose')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `purpose` varchar(25) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='financingInstitutionId')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `financingInstitutionId` BIGINT(20) NULL DEFAULT NULL,
ADD CONSTRAINT `fk_scholarship_financingInstitutionId` FOREIGN KEY (`financingInstitutionId`) REFERENCES `sponsors` (`id`);
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='scholarship' AND column_name='droolAgendaDescriptionOtherLanguage')) THEN 
ALTER TABLE `scholarship`
ADD COLUMN `droolAgendaDescriptionOtherLanguage` varchar(25) NULL DEFAULT NULL;
END IF;

END $$
CALL V20220922202852__Alter_AddNewColsToScholarship() $$
DROP PROCEDURE IF EXISTS V20220922202852__Alter_AddNewColsToScholarship $$
DELIMITER ;



























