DELIMITER $$
DROP PROCEDURE IF EXISTS V20220923172602__Insert_AccommodationProvider_DataSetting $$
CREATE PROCEDURE V20220923172602__Insert_AccommodationProvider_DataSetting()
BEGIN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
IF NOT EXISTS ((select * from id_column_available where tableName="accommodation_provider" and columnName="providerCode")) THEN 
INSERT INTO id_column_available (tableName, columnName) VALUES('accommodation_provider','providerCode');
END IF;

IF NOT EXISTS ((select * from id_entity_setting where tableName="accommodation_provider" and idGenerationTable="accommodation_provider")) THEN 
INSERT INTO id_entity_setting ( tableName, idGenerationTable,whetherFullyConfigurable,dynanicFieldAvailable, searchConfigCode, lastUpdatedBy, lastUpdate) VALUES('accommodation_provider','accommodation_provider',TRUE,TRUE,NULL,1,@currentTimeStamp);

SET @idEntitySettingId=(select id from id_entity_setting where tableName="accommodation_provider" and idGenerationTable="accommodation_provider");
END IF; 

IF NOT EXISTS ((select * from id_definition where idEntitySettingId=@idEntitySettingId and idColumn="providerCode")) THEN 
INSERT  INTO id_definition(idEntitySettingId,idFormatType,idColumn,whetherManualId,whetherDefaultID,lastUpdatedBy,lastUpdate,VERSION) VALUES ( @idEntitySettingId,'ALPHA_NUMERIC','providerCode',0,0,1,@currentTimeStamp,0);
SET @idDefinitionId=(select id from id_definition where idEntitySettingId=@idEntitySettingId and idColumn="providerCode");
END IF; 

IF NOT EXISTS ((select * from id_format where idDefinitionId=@idDefinitionId)) THEN 
INSERT  INTO id_format(idDefinitionId,seqNo,lastUpdatedBy,lastUpdate) VALUES (@idDefinitionId,1,1,@currentTimeStamp);
SET @idFormat=(select id from id_format where idDefinitionId=@idDefinitionId);
END IF; 

IF NOT EXISTS ((select * from id_format_alphanumeric where id=@idFormat)) THEN 
INSERT  INTO id_format_alphanumeric(id,prefix,suffix,startFrom) VALUES (@idFormat,'ACP','',1);
END IF; 


END $$
CALL V20220923172602__Insert_AccommodationProvider_DataSetting() $$
DROP PROCEDURE IF EXISTS V20220923172602__Insert_AccommodationProvider_DataSetting $$
DELIMITER ;