DELIMITER $$
DROP PROCEDURE IF EXISTS V20221007161219__Create_ApplicationTransferMsgEvent $$
CREATE PROCEDURE V20221007161219__Create_ApplicationTransferMsgEvent()
BEGIN
-- Application Transfer Notification
IF NOT EXISTS ((SELECT id FROM msg_category WHERE `code`='APPLICATION_TRANSFER_NOTIFICATION')) THEN 

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'APPLICATION_TRANSFER_NOTIFICATION');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPLICATION_TRANSFER_NOTIFICATION');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'APPLICATION_TRANSFER_NOTIFICATION', 'Application Transfer Notification', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Application Transfer Notification');

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_TRANSFER_NOTIFICATION_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_TRANSFER_NOTIFICATION_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_TRANSFER_NOTIFICATION_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select id  AS USER_ID from application where id IN (namedParams)",NULL);
-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 

    CONCAT(toacademyl3_.academyName,
            '-',
            toacademyl3_.locationName) AS TO_LOCATION,
    applicatio1_.code AS APPLICANT_ID,
    CONCAT(issuedfrom5_.academyName,
            '-',
            issuedfrom5_.locationName) AS FROM_LOCATION,
    CONCAT(person2_.firstName,
            IFNULL(person2_.middleName, ' '),
            IFNULL(person2_.lastName, ' ')) AS APPLICANT_NAME,
    batch7_.batchName AS BATCH_NAME,
    program8_.programName AS PROGRAM_NAME,
    (select IFNULL(itemValue, ' ') as  itemValue from registration_type as rt WHERE rt.id = program8_.registrationTypeId AND  program8_.registrationTypeId IS NOT NULL AND rt.id IS NOT NULL) AS PROGRAM_STATUS,
    (CASE
        WHEN
            (SELECT 
                    adu.defaultUserId
                FROM
                    application_default_user adu
                        INNER JOIN
                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id
                WHERE
                    adu.academyLocationId = toacademyl3_.id
                        AND adu.defaultUserId IS NOT NULL
                LIMIT 1)
        THEN
            (SELECT 
                    CONCAT(us.firstName,
                                IFNULL(us.middleName, ' '),
                                IFNULL(us.lastName, ' ')) AS name
                FROM
                    application_default_user adu
                        INNER JOIN
                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id
                        LEFT JOIN
                    users us ON us.id = adu.defaultUserId
                WHERE
                    adu.academyLocationId =toacademyl3_.id
                        AND adu.defaultUserId IS NOT NULL
                LIMIT 1)
        ELSE CONCAT(applicatio4_.firstName,
                IFNULL(applicatio4_.middleName, ' '),
                IFNULL(applicatio4_.lastName, ' '))
    END) AS APPLICANT_OWNER,
    (CASE
        WHEN
            (SELECT 
                    adu.defaultUserId
                FROM
                    application_default_user adu
                        INNER JOIN
                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id
                WHERE
                    adu.academyLocationId = toacademyl3_.id
                        AND adu.defaultUserId IS NOT NULL
                LIMIT 1)
        THEN
            (SELECT 
                    CONCAT(us.firstName,
                                IFNULL(us.middleName, ' '),
                                IFNULL(us.lastName, ' ')) AS name
                FROM
                    application_default_user adu
                        INNER JOIN
                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id
                        LEFT JOIN
                    users us ON us.id = adu.defaultUserId
                WHERE
                    adu.academyLocationId = toacademyl3_.id
                        AND adu.defaultUserId IS NOT NULL
                LIMIT 1)
        WHEN CONCAT(applicatio4_.firstName,
                IFNULL(applicatio4_.middleName, ' '),
                IFNULL(applicatio4_.lastName, ' ')) IS NOT NULL THEN 
        CONCAT(applicatio4_.firstName,
                IFNULL(applicatio4_.middleName, ' '),
                IFNULL(applicatio4_.lastName, ' '))        
        ELSE (select CONCAT(useradmin.firstName,
                IFNULL(useradmin.middleName, ' '),
                IFNULL(useradmin.lastName, ' ')) from users as useradmin  where code='SYSADMIN')
    END) AS FIRST_NAME,
    (CASE
        WHEN
            (SELECT 
                    adu.defaultUserId
                FROM
                    application_default_user adu
                        INNER JOIN
                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id
                WHERE
                    adu.academyLocationId = toacademyl3_.id
                        AND adu.defaultUserId IS NOT NULL
                LIMIT 1)
        THEN
            (SELECT 
                    usr.emailId AS name
                FROM
                    application_default_user adus
                        INNER JOIN
                    academy_location toacademyl35678_ ON adus.academyLocationId = toacademyl35678_.id
                        LEFT JOIN
                    users usr ON usr.id = adus.defaultUserId
                WHERE
                    adus.academyLocationId = toacademyl3_.id
                        AND adus.defaultUserId IS NOT NULL
                LIMIT 1)
        WHEN applicatio4_.emailId  IS NOT NULL THEN
            applicatio4_.emailId
        ELSE (select useradmin.emailId from users as useradmin  where code='SYSADMIN')
    END) AS EMAIL_ID,
  (CASE
        WHEN
            (SELECT 
                    adu.defaultUserId
                FROM
                    application_default_user adu
                        INNER JOIN
                    academy_location toacademyl356_ ON adu.academyLocationId = toacademyl356_.id
                WHERE
                    adu.academyLocationId = toacademyl3_.id
                        AND adu.defaultUserId IS NOT NULL
                LIMIT 1)
        THEN
            (SELECT 
                    per.mobileNumber AS name
                FROM
                    application_default_user adus
                        INNER JOIN
                    academy_location toacademyl35678_ ON adus.academyLocationId = toacademyl35678_.id
                        LEFT JOIN
                    users usr ON usr.id = adus.defaultUserId
                     LEFT JOIN staffs stt on stt.userId= usr.id
					 LEFT JOIN persons per on per.id= stt.personId
                WHERE
                    adus.academyLocationId = toacademyl3_.id
                        AND adus.defaultUserId IS NOT NULL
                LIMIT 1)
        WHEN applicatio4_22_.mobileNumber IS NOT NULL  THEN 
			applicatio4_22_.mobileNumber
        ELSE (select per.mobileNumber from users as useradmin   LEFT JOIN staffs stt on stt.userId= useradmin.id
					 LEFT JOIN persons per on per.id= useradmin.id where code='SYSADMIN') 
    END) AS MOBILE_NO, 
 applicatio1_.id  AS ID
FROM
    application_program this_
        INNER JOIN
    academy_location toacademyl3_ ON this_.academyLocationId = toacademyl3_.id
        LEFT OUTER JOIN
    currency currency12_ ON toacademyl3_.currencyId = currency12_.id
        INNER JOIN
    application applicatio1_ ON this_.applicationId = applicatio1_.id
        LEFT OUTER JOIN
    application_cf_data applicatio14_ ON applicatio1_.id = applicatio14_.applicationId
        INNER JOIN
    users applicatio4_ ON applicatio1_.applicationOwner = applicatio4_.id
        LEFT OUTER JOIN
    parents applicatio4_1_ ON applicatio4_.id = applicatio4_1_.userId
        LEFT OUTER JOIN
    staffs applicatio4_2_ ON applicatio4_.id = applicatio4_2_.userId
     LEFT OUTER JOIN
    persons applicatio4_22_ ON applicatio4_.id = applicatio4_22_.id
        LEFT OUTER JOIN
    students applicatio4_3_ ON applicatio4_.id = applicatio4_3_.userId
        INNER JOIN
    academy_location issuedfrom5_ ON applicatio1_.issuedFromAcademyLocation = issuedfrom5_.id
        INNER JOIN
    applicant_person person2_ ON applicatio1_.applicantPersonId = person2_.id
        LEFT OUTER JOIN
    reservation_category reservatio18_ ON applicatio1_.reservationCategoryId = reservatio18_.id
        LEFT OUTER JOIN
    application_program_cd applicatio19_ ON this_.id = applicatio19_.applicationProgramId
        INNER JOIN
    prog_batch_seat_config programbat6_ ON this_.progBatchSeatConfigId = programbat6_.id
        INNER JOIN
    batches batch7_ ON programbat6_.programBatchId = batch7_.id
        INNER JOIN
    programs program8_ ON batch7_.programId = program8_.id
        LEFT OUTER JOIN
    program_batch_seat_type_cd programbat24_ ON programbat6_.id = programbat24_.progBatchSeatConfigId
WHERE
    applicatio1_.id  IN (namedParams)
ORDER BY this_.lastUpdate DESC
LIMIT 1",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "TO_LOCATION",
            "resultKey": "TO_LOCATION",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "APPLICANT_ID",
            "resultKey": "APPLICANT_ID",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "FROM_LOCATION",
            "resultKey": "FROM_LOCATION",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "APPLICANT_NAME",
            "resultKey": "APPLICANT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "BATCH_NAME",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "itemValue",
            "resultKey": "PROGRAM_STATUS",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "ID",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 7        }
    ]}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='APPLICATION_TRANSFER_NOTIFICATION');


SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPLICATION_TRANSFER_NOTIFICATION');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='APPLICATION_TRANSFER_NOTIFICATION_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`,`whetherEnabled`) 
VALUES(@msgtemplateconfigId+1,'Application Transfer Notification',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Application Transfer Notification',NULL,'',NULL,'','APPROVED','','1','System Admin','1','English',b'1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Application Transferred','<html><head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;APPLICANT_OWNER&quot;]</strong>,</p>
			<p style="padding:0px 0px 0px 20px;">Please note that applicant- $recipientData[&quot;APPLICANT_NAME&quot;] - $recipientData[&quot;APPLICANT_ID&quot;] <br />
             has been transferred from $recipientData[&quot;FROM_LOCATION&quot;] to $recipientData[&quot;TO_LOCATION&quot;] <br />for the $recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_STATUS&quot;] intake </p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+2,@msgtemplateconfigId+1,'4','Application Transferred','<html><head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;APPLICANT_OWNER&quot;]</strong>,</p>
			<p style="padding:0px 0px 0px 20px;">Please note that applicant- $recipientData[&quot;APPLICANT_NAME&quot;] - $recipientData[&quot;APPLICANT_ID&quot;] <br />
             has been transferred from $recipientData[&quot;FROM_LOCATION&quot;] to $recipientData[&quot;TO_LOCATION&quot;] <br />for the $recipientData[&quot;PROGRAM_NAME&quot;]&nbsp;$recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_STATUS&quot;] intake </p>
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2','Transfer Approved','Dear $recipientData[&quot;APPLICANT_OWNER&quot;], Please note that applicant $recipientData[&quot;APPLICANT_NAME&quot;] $recipientData[&quot;APPLICANT_ID&quot;] has been transferred from $recipientData[&quot;FROM_LOCATION&quot;] to $recipientData[&quot;TO_LOCATION&quot;] for the $recipientData[&quot;PROGRAM_NAME&quot;] $recipientData[&quot;BATCH_NAME&quot;] $recipientData[&quot;PROGRAM_STATUS&quot;] intake');
END IF;

IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE  `key`='APPLICATION_TRANSFER_NOTIFICATION')) THEN 
INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICATION_TRANSFER_NOTIFICATION', 'Application Transfer Notification');
END IF;

END $$
CALL V20221007161219__Create_ApplicationTransferMsgEvent () $$ 
DROP PROCEDURE IF EXISTS V20221007161219__Create_ApplicationTransferMsgEvent $$ 
DELIMITER ;