DELIMITER $$
DROP PROCEDURE IF EXISTS V20221011210901__Create_FunctionaryDetailsTable $$
CREATE PROCEDURE V20221011210901__Create_FunctionaryDetailsTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='person_functionary_details')) THEN 
CREATE TABLE `person_functionary_details`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `personId` BIGINT(20) NOT NULL,
  `functionaryTypeId` BIGINT(20) NULL,
  `functionaryUserId` BIGINT(20) NULL,
  `functionaryUserRole` VARCHAR(255) NULL,
  `functionaryInvolvementInPercentage` VARCHAR(10) NULL,
  `startDate` Date NULL,
  `endDate` Date NULL,
  `activeStatus` bit(1) DEFAULT b'1',
  `auditDate` Date NULL,
  `auditId` BIGINT(20) NULL,
  `description` VARCHAR(255) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `functionary_details_personId_FK` FOREIGN KEY (`personId`) REFERENCES `persons`(`id`),
  CONSTRAINT `functionary_details_functionaryTypeId_FK` FOREIGN KEY (`functionaryTypeId`) REFERENCES `functionary_type`(`id`),
  CONSTRAINT `functionary_details_functionaryUserId_FK` FOREIGN KEY (`functionaryUserId`) REFERENCES `users`(`id`),
  CONSTRAINT `functionary_details_auditId_FK` FOREIGN KEY (`auditId`) REFERENCES `users`(`id`),
  CONSTRAINT `functionary_details_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`));
END IF; 

END $$
CALL V20221011210901__Create_FunctionaryDetailsTable () $$ 
DROP PROCEDURE IF EXISTS V20221011210901__Create_FunctionaryDetailsTable $$ 
DELIMITER ;