DELIMITER $$
DROP PROCEDURE IF EXISTS V20221121113934__Create_StudentThesisUploadTable $$
CREATE PROCEDURE V20221121113934__Create_StudentThesisUploadTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_thesis_upload')) THEN 
CREATE TABLE `student_thesis_upload`(  
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `personId` BIGINT(20) NOT NULL,
  `details` VARCHAR(255) DEFAULT NULL,
  `auditDate` Date DEFAULT NULL,
  `auditId` BIGINT(20) DEFAULT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `student_thesis_upload_personId_FK` FOREIGN KEY (`personId`) REFERENCES `persons`(`id`),
  CONSTRAINT `student_thesis_upload_auditId_FK` FOREIGN KEY (`auditId`) REFERENCES `users`(`id`),
  CONSTRAINT `student_thesis_upload_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20221121113934__Create_StudentThesisUploadTable () $$ 
DROP PROCEDURE IF EXISTS V20221121113934__Create_StudentThesisUploadTable $$ 
DELIMITER ;