DELIMITER $$
DROP PROCEDURE IF EXISTS V20230102143522__Update_CourseEnrollInfoAddDataProvider $$
CREATE PROCEDURE V20230102143522__Update_CourseEnrollInfoAddDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO')) THEN 
update dydt_data_line_item set resultColumnsDef  ='COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD, EXAM_DATE, EXAM_START_TIME, EXAM_END_TIME',
sqlSelectQueryDef =  "SELECT c.courseCode AS COURSE_CODE , 
c.courseName AS COURSE_NAME, 
FLOOR ( c.courseCredits) AS COURSE_CREDITS, 
pbpc.printName AS PERIOD , ss.examDate AS EXAM_DATE, 
DATE_FORMAT(ss.examStartTime,'%h:%i %p') AS EXAM_START_TIME, 
DATE_FORMAT(ss.examEndTime,'%h:%i %p') AS EXAM_END_TIME
from student_course_enrollment sce
inner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
inner join admission adm on adm.id=sce.admissionId
inner join course_variants cv on cv.id=sce.courseVarientId
INNER JOIN sections ss on ss.id = sce.sectionId
left join courses c on c.id=cv.courseId"
where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO';

SET @dydtdatalinitemId=(select min(id) from dydt_data_line_item where dataSourceCode='STUDENT_COURSE_ENROLLMENT_INFO');
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES 
('EXAM_DATE', 'Exam Date',@dydtdatalinitemId),
('EXAM_START_TIME', 'Exam Start Date',@dydtdatalinitemId),
('EXAM_END_TIME', 'Exam End Date',@dydtdatalinitemId);

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230102143522__Update_CourseEnrollInfoAddDataProvider () $$
DROP PROCEDURE IF EXISTS V20230102143522__Update_CourseEnrollInfoAddDataProvider $$
DELIMITER ;