DELIMITER $$
DROP PROCEDURE IF EXISTS V20230117120227__Insert_EmailServerConf_OSM $$
CREATE PROCEDURE V20230117120227__Insert_EmailServerConf_OSM()
BEGIN

SET @standardMasterId=(select id from standard_master where tableName = 'email_server_configuration');
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE  dbFieldName='isUseBedayaSMTP' AND fieldLabel='IS_USE_BEDAYA_SMTP' AND standardMasterId=@standardMasterId)) THEN 
INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, 
`whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES ('isUseBedayaSMTP', 'IS_USE_BEDAYA_SMTP', @standardMasterId, 'Boolean', '10', 0, 0, 0, 1, '1',now());

END IF; 

-- translations
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS' and keyName = 'IS_USE_BEDAYA_SMTP')) THEN 
INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
VALUES ('TRANSLATIONS', 'IS_USE_BEDAYA_SMTP', 'Is Use Bedaya SMTP', 'Is Use Bedaya SMTP','Is Gebruik Bedaya SMTP','Đang sử dụng Bedaya SMTP',now(),1);
END IF; 

END $$
CALL V20230117120227__Insert_EmailServerConf_OSM() $$
DROP PROCEDURE IF EXISTS V20230117120227__Insert_EmailServerConf_OSM $$
DELIMITER ;