DELIMITER $$
DROP PROCEDURE IF EXISTS V20230213170712__Create_calculate_average_yearly $$
CREATE PROCEDURE V20230213170712__Create_calculate_average_yearly()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='calculate_average_yearly')) THEN 

CREATE TABLE `calculate_average_yearly` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `admissionId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `periodYearId` BIGINT(20) NULL DEFAULT NULL,
  `average` FLOAT NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_calculate_average_yearly_admissionId_idx` (`admissionId` ASC) ,
  INDEX `fk_calculate_average_yearly_batchId_idx` (`batchId` ASC) ,
  INDEX `fk_calculate_average_yearly_periodYearId_idx` (`periodYearId` ASC) ,
  INDEX `fk_calculate_average_yearly_lastupdateby_idx` (`lastUpdatedBy` ASC) ,
  UNIQUE INDEX `fk_calculate_average_yearly_unique_idx` (`admissionId` ASC, `batchId` ASC, `periodYearId` ASC) ,
  CONSTRAINT `fk_calculate_average_yearly_admissionId`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_calculate_average_yearly_batchId`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_calculate_average_yearly_periodYearId`
    FOREIGN KEY (`periodYearId`)
    REFERENCES `period_year` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_calculate_average_yearly_lastupdateby`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
    
END IF; 

END $$
CALL V20230213170712__Create_calculate_average_yearly () $$ 
DROP PROCEDURE IF EXISTS V20230213170712__Create_calculate_average_yearly $$ 
DELIMITER ;