DELIMITER $$
DROP PROCEDURE IF EXISTS V20230214154841__Create_CreateTableLessionPlanStaff $$
CREATE PROCEDURE V20230214154841__Create_CreateTableLessionPlanStaff()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='lesson_plan_staff')) THEN 
create table IF NOT EXISTS lesson_plan_staff(id bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  lessonPlanId bigint(20) NOT NULL,
  staffId bigint(20) NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  lastUpdatedBy bigint(20) NOT NULL,
  CONSTRAINT RefuserLessonPlanCV FOREIGN KEY (lastUpdatedBy) REFERENCES users(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT ReflppLessonPlanCV FOREIGN KEY (lessonPlanId) REFERENCES lesson_plan(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT RefstaffLessonPlanCV FOREIGN KEY (staffId) REFERENCES staffs(userId)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
  UNIQUE KEY id_unk_lesson_plan_staff(lessonPlanId, staffId)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 comment = 'Lesson Plan and Staff Tables mapping, might be one to many';
END IF; 

END $$
CALL V20230214154841__Create_CreateTableLessionPlanStaff () $$ 
DROP PROCEDURE IF EXISTS V20230214154841__Create_CreateTableLessionPlanStaff $$ 
DELIMITER ;