DELIMITER $$
DROP PROCEDURE IF EXISTS V20230215155705__Create_ExternalCoSupervisorBDataProvider $$
CREATE PROCEDURE V20230215155705__Create_ExternalCoSupervisorBDataProvider()
BEGIN

IF NOT EXISTS ((select * from dydt_data_line_item where dataSourceCode='EXTERNAL_CO_SUPERVISOR_B_INFO')) THEN 
INSERT INTO `dydt_data_provider` (`id`,`providerName`, `priority`) VALUES (@dydtdataproviderId+1,'External Co-Supervisor B', '1');
SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId=(SELECT id FROM `dydt_data_provider` where providerName='External Co-Supervisor B');

INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'EXTERNAL_CO_SUPERVISOR_B_INFO', '1',null, '1', '1', 
"SELECT T1.id AS id,
T4.firstName AS first_name,
T4.middleName AS middle_name,
T4.lastName AS last_name,
T4.alternateEmailId AS alternative_email_id,
T4.emailId AS email_id,
T4.phoneNo AS telephone_no,
T4.mobileNumber AS mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') as address
from users T1
left join students T2 on T2.userId=T1.id
left join person_functionary_details T3 on T3.personId=T2.personId
left join functionary_type on functionary_type.id=T3.functionaryTypeId 
left join staffs T5 on T5.userId=T3.functionaryUserId and functionary_type.itemCode='External Co-Supervisor B'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId"
,
    'PGM_USER_ID', 'first_name,middle_name,last_name,address,email_id,alternative_email_id,telephone_no,mobile_no', 'where T1.id=PGM_USER_ID order by T3.id desc limit 1;','0');

#------------------TRANSLATIONS---------------------
   
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('first_name', 'External Co-Supervisor B First Name',@dydtdatalinitemId+1),
    ('middle_name', 'External Co-Supervisor B Middle Name',@dydtdatalinitemId+1),
    ('last_name', 'External Co-Supervisor B Last Name',@dydtdatalinitemId+1),
    ('address', 'External Co-Supervisor B Address',@dydtdatalinitemId+1),
    ('email_id', 'External Co-Supervisor B Email ID',@dydtdatalinitemId+1),
    ('alternative_email_id', 'External Co-Supervisor B Alternative Email ID',@dydtdatalinitemId+1),
    ('telephone_no', 'External Co-Supervisor B Telephone No.',@dydtdatalinitemId+1),
    ('mobile_no', 'External Co-Supervisor B Mobile No.',@dydtdatalinitemId+1);
    
END IF; 

END $$
CALL V20230215155705__Create_ExternalCoSupervisorBDataProvider () $$ 
DROP PROCEDURE IF EXISTS V20230215155705__Create_ExternalCoSupervisorBDataProvider $$ 
DELIMITER ;