DELIMITER $$
DROP PROCEDURE IF EXISTS V20230216155214__Insert_CommitteeCreationLoader $$
CREATE PROCEDURE V20230216155214__Insert_CommitteeCreationLoader()
BEGIN

IF NOT EXISTS ((SELECT * FROM import_utility_master WHERE screenName='Bulk Committee Creation' AND code ='bulkCommitteeCreation')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`) 
VALUES ('Bulk Committee Creation', 'committee/committeecreation', 'bulkCommitteeCreation', '1');
END IF;  

IF EXISTS ((SELECT * FROM import_utility_master WHERE code = 'bulkCommitteeCreation')) THEN 
SET @masterId = (select id from import_utility_master WHERE code='bulkCommitteeCreation');

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='COMMITTEE_CODE_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('COMMITTEE_CODE_HEADER','Committee Code','Committee Code',1,now(),1,1,1,@masterId,1,NULL),('COMMITTEE_CODE_HEADER','Committee Code','Committee Code',0,now(),1,1,1,@masterId,1,NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='COMMITTEE_NAME_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('COMMITTEE_NAME_HEADER','Committee Name','Committee Name',1,now(),1,1,1,@masterId,1,NULL),('COMMITTEE_NAME_HEADER','Committee Name','Committee Name',0,now(),1,1,1,@masterId,1,NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='COMMITTEE_COORDINATOR_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('COMMITTEE_COORDINATOR_HEADER','Committee Coordinator','Committee Coordinator',1,now(),1,1,1,@masterId,1,NULL),('COMMITTEE_COORDINATOR_HEADER','Committee Coordinator','Committee Coordinator',0,now(),1,1,1,@masterId,1,NULL);
END IF;  

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='COMMITTEE_TYPE_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('COMMITTEE_TYPE_HEADER','Committee Type','Committee Type',1,now(),1,1,1,@masterId,1,NULL),('COMMITTEE_TYPE_HEADER','Committee Type','Committee Type',0,now(),1,1,1,@masterId,1,NULL);
END IF;  

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='FROM_DATE_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('FROM_DATE_HEADER','From Date','From Date',1,now(),1,0,0,@masterId,1,NULL),('FROM_DATE_HEADER','From Date','From Date',0,now(),1,0,0,@masterId,1,NULL);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='TO_DATE_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('TO_DATE_HEADER','To Date','To Date',1,now(),1,0,0,@masterId,1,NULL),('TO_DATE_HEADER','To Date','To Date',0,now(),1,0,0,@masterId,1,NULL);
END IF; 

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='STATUS_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('STATUS_HEADER','Status','Status',1,now(),1,0,0,@masterId,1,NULL),('STATUS_HEADER','Status','Status',0,now(),1,0,0,@masterId,1,NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM loader_header WHERE importUtilityMasterId=@masterId AND headerCode='DESCRIPTION_HEADER')) THEN 
INSERT INTO loader_header(headerCode,defaultHeaderLabel,headerLabel,isSchool,lastUpdate,lastUpdatedBy,isNonEditable,isMandatory,importUtilityMasterId,isVisible,defaultValue)
VALUES('DESCRIPTION_HEADER','Description','Description',1,now(),1,0,0,@masterId,1,NULL),('DESCRIPTION_HEADER','Description','Description',0,now(),1,0,0,@masterId,1,NULL);
END IF;

END IF;

END $$
CALL V20230216155214__Insert_CommitteeCreationLoader() $$
DROP PROCEDURE IF EXISTS V20230216155214__Insert_CommitteeCreationLoader $$
DELIMITER ;