DELIMITER $$
DROP PROCEDURE IF EXISTS V20230227165913__Create_Business_Attribute_Rule $$
CREATE PROCEDURE V20230227165913__Create_Business_Attribute_Rule()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='business_attribute_rule')) THEN 
CREATE TABLE business_attribute_rule (
  id bigint NOT NULL AUTO_INCREMENT,
  attributeTypeId bigint NOT NULL,
  attributeRuleName varchar(45) NOT NULL,
  applicableOn varchar(45)  NULL,
  lastUpdatedBy bigint NOT NULL,
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY fk_attributeTypeId_idx (attributeTypeId),
  KEY fk_flag_configuration_detail_lastUpdatedBy_idx (lastUpdatedBy),
  CONSTRAINT fk_attribute_type_attributeTypeId FOREIGN KEY (attributeTypeId) REFERENCES attribute_type (id),
  CONSTRAINT fk_business_attribute_rule_lastUpdatedBy FOREIGN KEY (lastUpdatedBy) REFERENCES users (id)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20230227165913__Create_Business_Attribute_Rule () $$ 
DROP PROCEDURE IF EXISTS V20230227165913__Create_Business_Attribute_Rule $$ 
DELIMITER ;