DELIMITER $$
DROP PROCEDURE IF EXISTS V20230419112438__Update_attandanceMSGEventDLRecipint $$
CREATE PROCEDURE V20230419112438__Update_attandanceMSGEventDLRecipint()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='MSG_COURSEWISE_WEEKLY_ATTENDANCE_DL')) THEN 
  SET @attendanceDL=(select id from dtprovider d WHERE d.dataProviderName='MSG_COURSEWISE_WEEKLY_ATTENDANCE_DL');
 UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT  T5.studentId AS USER_ID
 FROM
     student_course_attendance T1
         LEFT JOIN
     student_course_attendance_details T2 ON T2.attendanceId = T1.id
         LEFT JOIN
     admission T5 ON T5.id = T2.admissionId AND T5.activeStatus =true  
  where T5.academyLocationId  = (SELECT  academyLocation FROM  schedule_event_trigger_details where status='Start' and displayCode = 'MSG_COURSEWISE_WEEKLY_ATTENDACE_REPORT'  and triggeredOn =(SELECT max(triggeredOn)  FROM  schedule_event_trigger_details where displayCode = 'MSG_COURSEWISE_WEEKLY_ATTENDACE_REPORT')  LIMIT 1)
 GROUP BY T2.admissionId "
 WHERE  dataProviderId =@attendanceDL;
END IF;


IF EXISTS ((select * from dtprovider d WHERE d.dataProviderName='MSG_COURSEWISE_WEEKLY_ATTENDANCE_RCPNT')) THEN 
  SET @attendanceRCPNT=(select id from dtprovider d WHERE d.dataProviderName='MSG_COURSEWISE_WEEKLY_ATTENDANCE_RCPNT');
 UPDATE `sql_dtprovider` SET `sqlQuery`="  SELECT 
    T5.studentId AS ID,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobilecountrycode AS MOBILE_CODE,
    T3.nameToBePrinted AS COURSE_NAME,
    T3.courseCode AS COURSE_CODE,
    T11.componentType AS COMPONENT_DESC,
    T9.firstName AS FACULTY_FIRSTNAME,
    T9.lastName AS FACULTY_LASTNAME,
    T10.salutationName AS SALUTATION,
    T15.printName AS BATCH_NAME,
    T16.programNameToBePrint AS PROGRAM_NAME,
    T17.printName AS PERIOD_NAME,
    T18.displayName AS ACADEMY_NAME,
     ml.code as LANGUAGE_KEY,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_SESSIONS`,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_PRESENT`,
    COUNT(IF(scad.attendanceStatus = 'ABSENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_ABSENT`,
    COUNT(IF(scad.attendanceStatus = 'LEAVE',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_LEAVE`,
    ROUND((COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) / (COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
                scad.attendanceStatus,
                NULL)))) * 100) AS `PRESENT_PERCENTAGE`
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    courses T3 ON T3.id = sca.courseId
        LEFT JOIN
    course_components T4 ON T4.id = sca.courseComponentId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    staffs T8 ON T8.userId = sca.facultyId
        LEFT JOIN
    persons T9 ON T9.id = T8.personId
        LEFT JOIN
    salutations T10 ON T10.id = T9.salutationId
        LEFT JOIN
    component_type T11 ON T11.id = T4.componentTypeId
        LEFT JOIN
    program_batch_students T14 ON T14.admissionId = T5.id
        LEFT JOIN
    batches T15 ON T15.id = T14.programBatchId
        LEFT JOIN
    programs T16 ON T16.id = T15.programId
        LEFT JOIN
    prog_batch_period_config T17 ON T17.id = T14.progBatchPeriodConfigId
        LEFT JOIN
    academy_location T18 ON T18.id = T16.academyLocationId
		LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id
WHERE
    T5.studentId IN (namedParams) and T14.isCurrentPeriod=true and T14.isCurrentSection=true AND sca.variantId IN (
   SELECT sce.courseVarientId FROM  student_course_enrollment sce 
   LEFT JOIN program_batch_students pbs ON pbs.admissionId = sce.admissionId AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId
    LEFT JOIN admission a ON a.id= pbs.admissionId
   WHERE a.studentId IN (namedParams) AND pbs.isCurrentPeriod = TRUE AND pbs.isCurrentSection =TRUE AND pbs.isPeriodCompleted =false
	 )
GROUP BY sca.courseid , sca.courseComponentId , sca.sectionId , sca.variantId , T5.studentId
ORDER BY sca.courseId DESC"
 WHERE  dataProviderId =@attendanceRCPNT;
END IF; 



SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230419112438__Update_attandanceMSGEventDLRecipint () $$
DROP PROCEDURE IF EXISTS V20230419112438__Update_attandanceMSGEventDLRecipint $$
DELIMITER ;