DELIMITER $$
DROP PROCEDURE IF EXISTS V20230509142732__Update_ExternalCoSupervisorBDataProvider $$
CREATE PROCEDURE V20230509142732__Update_ExternalCoSupervisorBDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'EXTERNAL_CO_SUPERVISOR_B_INFO')) THEN 
UPDATE dydt_data_line_item
SET whereClauseBindingDef = 'PRM_ADMISSION_ID', sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS external_co_supervisor_b_first_name,
T4.middleName AS external_co_supervisor_b_middle_name,
T4.lastName AS external_co_supervisor_b_last_name,
T4.alternateEmailId AS external_co_supervisor_b_alternative_email_id,
T4.emailId AS external_co_supervisor_b_email_id,
T4.phoneNo AS external_co_supervisor_b_telephone_no,
T4.mobileNumber AS external_co_supervisor_b_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') as external_co_supervisor_b_address,
T13.code AS external_co_supervisor_b_id,
T11.salutationName AS external_co_supervisor_b_title,
T12.itemValue AS external_co_supervisor_b_gender
from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join person_functionary_details T3 on T3.personId=T2.personId
left join functionary_type on functionary_type.id=T3.functionaryTypeId 
left join staffs T5 on T5.userId=T3.functionaryUserId and functionary_type.itemCode='External Co-Supervisor B'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.functionaryUserId"

,resultColumnsDef="external_co_supervisor_b_first_name,external_co_supervisor_b_middle_name,external_co_supervisor_b_last_name,external_co_supervisor_b_address,external_co_supervisor_b_email_id,external_co_supervisor_b_alternative_email_id,external_co_supervisor_b_telephone_no,external_co_supervisor_b_mobile_no,external_co_supervisor_b_id,external_co_supervisor_b_title,external_co_supervisor_b_gender"
WHERE dataSourceCode = 'EXTERNAL_CO_SUPERVISOR_B_INFO';

#------------------TRANSLATIONS---------------------
  
	SET @dydtdatalinitemId = (SELECT id FROM `dydt_data_line_item` where dataSourceCode='EXTERNAL_CO_SUPERVISOR_B_INFO');
  
    INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
    VALUES ('external_co_supervisor_b_id', 'External Co-Supervisor B ID',@dydtdatalinitemId),
    ('external_co_supervisor_b_title', 'External Co-Supervisor B Title',@dydtdatalinitemId),
    ('external_co_supervisor_b_gender', 'External Co-Supervisor B Gender',@dydtdatalinitemId);

END IF;
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230509142732__Update_ExternalCoSupervisorBDataProvider () $$
DROP PROCEDURE IF EXISTS V20230509142732__Update_ExternalCoSupervisorBDataProvider $$
DELIMITER ;