DELIMITER $$
DROP PROCEDURE IF EXISTS V20230515122927__Update_InternalExaminerBDataProvider $$
CREATE PROCEDURE V20230515122927__Update_InternalExaminerBDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from dydt_data_line_item where dataSourceCode = 'INTERNAL_EXAMINER_B_INFO')) THEN 
UPDATE dydt_data_line_item
SET whereClauseBindingDef = 'PRM_ADMISSION_ID', sqlSelectQueryDef= "SELECT T1.id AS id,
T4.firstName AS internal_examiner_b_first_name,
T4.middleName AS internal_examiner_b_middle_name,
T4.lastName AS internal_examiner_b_last_name,
T4.alternateEmailId AS internal_examiner_b_alternative_email_id,
T4.emailId AS internal_examiner_b_email_id,
T4.phoneNo AS internal_examiner_b_telephone_no,
T4.mobileNumber AS internal_examiner_b_mobile_no,
    CONCAT(T7.addressText,',',T9.countryName,',',T10.countryRegionName,',',T7.pincode,',') AS internal_examiner_b_address,
T13.code AS internal_examiner_b_id,
T11.salutationName AS internal_examiner_b_title,
T12.itemValue AS internal_examiner_b_gender,
T14.itemValue AS internal_examiner_b_nationality,

T15.employer AS internal_examiner_b_employer_or_institution,
T15.department AS internal_examiner_b_department,
T15.designation AS internal_examiner_b_position_or_occupation,
T15.areaOfExpertise AS internal_examiner_b_area_of_expertise_or_specialisation,
T7.faxNumber AS internal_examiner_b_fax_no,
T4.highestQualification AS internal_examiner_b_highest_qualification,
T4.awardingInstitution AS internal_examiner_b_awarding_institution,
T16.numberOfPhDsSupervisedOverLastFiveYears AS internal_examiner_b_number_of_phds_supervised_over_the_last_5_years,
T16.numberOfPhDsCompleted AS internal_examiner_b_number_of_phds_completed,
T16.numberOfCurrentPhDStudents AS internal_examiner_b_number_of_current_phds_students,
T16.numberOfMasterDegreeSupervisedOverFiveYears AS internal_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years,
T16.numberOfMasterDegreeCompleted AS internal_examiner_b_number_of_masters_degrees_completed,
T16.numberOfCurrentMasterStudents AS internal_examiner_b_number_of_current_masters_students,
T16.numberOfArticlesInPeerReviewedOrRefereedJournals AS internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals,
T16.numberOfArticlesInPeerReviewedOrRefereedJournalsAsFirst AS internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,
T16.numberOfPublishedConferencePapers AS internal_examiner_b_number_of_published_conference_papers,
T16.numberOfPublishedConferencePapersAsFirst AS internal_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author,
T16.numberOfConferencesAndSymposia AS internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations,
T16.numberOfConferencesAndSymposiaAsFirst AS internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,
T16.deviationFromNormalRequirements AS internal_examiner_b_motivate_deviation_from_normal_requirements,
T16.nominationOfExternalExaminer AS internal_examiner_b_nomination_of_external_examiner,
T16.numberOfPHDsExamined AS internal_examiner_b_number_of_phds_examined,
T16.numberOfMastersExamined AS internal_examiner_b_number_of_masters_examined


from admission
left join users T1 on T1.id=admission.studentId
left join students T2 on T2.userId=T1.id
left join nominate_examiners T3 on T3.personId=T2.personId
left join examiner_type on examiner_type.id=T3.examinerType 
left join staffs T5 on T5.userId=T3.examinerName and examiner_type.itemCode='Internal Examiner B'
left join  persons T4 on T4.id=T5.personId
left join person_addresses T6  on T6.personId=T5.personId and T6.addressTypeId=5
left join address T7 on T7.id=T6.addressId
left join city T8 on T8.id=T7.cityId
left join country T9 on T9.id=T8.countryId
left join country_region T10 on T10.id=T8.countryRegionId
left join salutations T11 on T11.id=T4.salutationId
left join gender T12 on T12.id=T4.genderId
left join users T13 on T13.id =T3.personId
left join nationalities T14 on T14.id =T4.nationalityId
left join work_experience T15 on T15.personId=T5.personId
left join employees_additional_information T16 on T16.userId=T5.userId"
,resultColumnsDef="internal_examiner_b_first_name,internal_examiner_b_middle_name,internal_examiner_b_last_name,internal_examiner_b_address,internal_examiner_b_email_id,internal_examiner_b_alternative_email_id,internal_examiner_b_telephone_no,internal_examiner_b_mobile_no,internal_examiner_b_id,internal_examiner_b_title,internal_examiner_b_gender,internal_examiner_b_nationality,internal_examiner_b_employer_or_institution,internal_examiner_b_department,internal_examiner_b_position_or_occupation,internal_examiner_b_area_of_expertise_or_specialisation,internal_examiner_b_fax_no,internal_examiner_b_highest_qualification,internal_examiner_b_awarding_institution,internal_examiner_b_number_of_phds_supervised_over_the_last_5_years,internal_examiner_b_number_of_phds_completed,internal_examiner_b_number_of_current_phds_students,internal_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years,internal_examiner_b_number_of_masters_degrees_completed,internal_examiner_b_number_of_current_masters_students,internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals,internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author,internal_examiner_b_number_of_published_conference_papers,internal_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author,internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations,internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author,internal_examiner_b_motivate_deviation_from_normal_requirements,internal_examiner_b_nomination_of_external_examiner,internal_examiner_b_number_of_phds_examined,internal_examiner_b_number_of_masters_examined",sqlWhereQueryDef="WHERE admission.id = PRM_ADMISSION_ID and examiner_type.itemCode='Internal Examiner B' order by T3.id  desc limit 1;"
WHERE dataSourceCode = 'INTERNAL_EXAMINER_B_INFO';

#------------------TRANSLATIONS---------------------
  
SET @dydtdatalinitemId = (SELECT id FROM `dydt_data_line_item` where dataSourceCode='INTERNAL_EXAMINER_B_INFO');  
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) 
VALUES('internal_examiner_b_employer_or_institution', 'Internal Examiner B Employer/Institution', @dydtdatalinitemId),
('internal_examiner_b_department', 'Internal Examiner B Department', @dydtdatalinitemId),
('internal_examiner_b_position_or_occupation', 'Internal Examiner B Position/Occupation',@dydtdatalinitemId),
('internal_examiner_b_area_of_expertise_or_specialisation', 'Internal Examiner B Area of expertise/Specialisation',@dydtdatalinitemId),
('internal_examiner_b_fax_no', 'Internal Examiner B Fax No.', @dydtdatalinitemId),
('internal_examiner_b_highest_qualification', 'Internal Examiner B Highest qualification',@dydtdatalinitemId),
('internal_examiner_b_awarding_institution', 'Internal Examiner B Awarding institution', @dydtdatalinitemId),
('internal_examiner_b_number_of_phds_supervised_over_the_last_5_years', 'Internal Examiner B Number of PhDs supervised over the last 5 years', @dydtdatalinitemId),
('internal_examiner_b_number_of_phds_completed', 'Internal Examiner B Number of PhDs completed', @dydtdatalinitemId),
('internal_examiner_b_number_of_current_phds_students', 'Internal Examiner B Number of current PhD students', @dydtdatalinitemId),
('internal_examiner_b_number_of_masters_degrees_supervised_over_the_last_5_years', 'Internal Examiner B Number of Masters degrees supervised over the last 5 years',@dydtdatalinitemId),
('internal_examiner_b_number_of_masters_degrees_completed', 'Internal Examiner B Number of Masters degrees completed', @dydtdatalinitemId),
('internal_examiner_b_number_of_current_masters_students', 'Internal Examiner B Number of current Masters students', @dydtdatalinitemId),
('internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals', 'Internal Examiner B Number of articles in peer-reviewed or refereed journals',@dydtdatalinitemId),
('internal_examiner_b_number_of_articles_in_peer_reviewed_or_refereed_journals_as_first_or_corresponding_author', 'Internal Examiner B Number of articles in peer-reviewed or refereed journals as first or corresponding author',@dydtdatalinitemId),
('internal_examiner_b_number_of_published_conference_papers', 'Internal Examiner B Number of published conference papers', @dydtdatalinitemId),
('internal_examiner_b_number_of_published_conference_papers_as_first_or_corresponding_author', 'Internal Examiner B Number of published conference papers as first or corresponding author',@dydtdatalinitemId),
('internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations', 'Internal Examiner B Number of Conferences and symposia Oral/Poster presentations',@dydtdatalinitemId),
('internal_examiner_b_number_of_conferences_and_symposia_oral_or_poster_presentations_as_first_or_corresponding_author', 'Internal Examiner B Number of Conferences and symposia Oral/Poster presentations as first or corresponding author',@dydtdatalinitemId),
('internal_examiner_b_motivate_deviation_from_normal_requirements', 'Internal Examiner B Motivate deviation from normal requirements', @dydtdatalinitemId),
('internal_examiner_b_nomination_of_external_examiner', 'Internal Examiner B Nomination of External Examiner', @dydtdatalinitemId),
('internal_examiner_b_number_of_phds_examined', 'Internal Examiner B Number of PhDs Examined', @dydtdatalinitemId),
('internal_examiner_b_number_of_masters_examined', 'Internal Examiner B Number of Masters  Examined', @dydtdatalinitemId);

END IF; SET SQL_SAFE_UPDATES=1;
END $$
CALL V20230515122927__Update_InternalExaminerBDataProvider () $$
DROP PROCEDURE IF EXISTS V20230515122927__Update_InternalExaminerBDataProvider $$
DELIMITER ;