DELIMITER $$
DROP PROCEDURE IF EXISTS V20230715124944__Create_MonthlyReportMasterTranslationOSM $$
CREATE PROCEDURE V20230715124944__Create_MonthlyReportMasterTranslationOSM()
BEGIN
IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='monthly_report_master_osm')) THEN 
CREATE TABLE `monthly_report_master_osm` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `gridDisplayColumn` varchar(255) NOT NULL,
  `summary_display_column` varchar(255) DEFAULT NULL,
  `status` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
END IF;
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);

IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'MONTHLY_REPORT_MASTER_OSM')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'monthly_report_master_osm','MONTHLY_REPORT_MASTER_OSM','tools & services','MASTER_WITH_AL',0,0,NULL,1,@currentTimeStamp);
END IF;
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`,
`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES 
('status', 'STATUS', @standardMasterMaxId+1, 'Boolean', '3', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('gridDisplayColumn', 'GRID_DISPLAY_COLUMN', @standardMasterMaxId+1, 'Varchar', '1', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('summary_display_column', 'SUMMARY_DISPLAY_COLUMN', @standardMasterMaxId+1, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE());
-- ------------------TRANSLATION------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'masterNames' and keyName = 'MONTHLY_REPORT_MASTER_OSM')) THEN 
		INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
		VALUES ('masterNames', 'MONTHLY_REPORT_MASTER_OSM', 'MONTHLY REPORT MASTER OSM','Monthly Report Master Osm','Maandelikse Verslag Meester Osm','Báo cáo hàng tháng Master Osm',now(),1);
END IF;

-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (1,'No. of Als','Academy Locations',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (2,'Programs','Programs',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (3,'Courses','Courses',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (4,'No. of employees','Active  Employees',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (5,'No. of Employees (InActive','No. of Employees (InActive',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (6,'No. of students','Active Students',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (7,'No. of Students (Inactive)','No. of Students (Inactive)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (8,'Facilities and master(Classrooms)','Facilities and master(Classrooms)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (9,'Facilitie','Facilitie',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (10,'Attendance Sessions (Coursewise attendance sessions)','Attendance Sessions (Corsewise attendance sessions)',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (11,'Attendance Sessions (Complete day attendance sessions)','Attendance Sessions (Complete day attendance sessions)',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (12,'Homework and assignments shared','Homework and assignments shared',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (13,'Marks entered','Marks entered',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (14,'No. of applications created','No. of applications created',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (15,'Academic Events created during the month','Academic Events created during the month',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (16,'No. of mark sheets generated','No. of mark sheets generated',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (17,'Bills generated','Bills generated',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (18,'Receipts generated','Receipts generated',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (19,'Receipts generated (Online Mode)','Receipts generated (Online Mode)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (20,'Receipts generated (Payment Gateways)','Receipts generated (Payment Gateways)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (21,'No. Of Emails Sent','No. Of Emails Sent',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (22,'No. Of SMS Sent','No. Of SMS Sent',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (23,'Hostel Allocation','Hostel Allocation',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (24,'Enquiries generated','Enquiries generated',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (25,'Non Academic Events created during the month','Non Academic Events created during the month',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (26,'Leave applications','Leave applications',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (27,'Push Notifications for the month','Push Notifications for the month',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (28,'Student Requests','Student Requests',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (29,'No. of Employee Request (during the month)','No. of Employee Request (during the month)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (30,'No. of Students documents uploaded (during the month)','No. of Students documents uploaded (during the month)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (31,'No. of Staff documents uploaded (during the month)','No. of Staff documents uploaded (during the month)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (32,'Total Fee Plans Created (during the month)','Total Fee Plans Created (during the month)',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (33,'Is Password Policy implemented Yes or No','Is Password Policy implemented Yes or No',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (34,'Faculty login count to Responsive Faculty Portal','Faculty login count to Responsive Faculty Portal',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (35,'Faculty login count to regular faculty portal','Faculty login count to regular faculty portal',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (36,'Msg Birthday Greeting','Msg Birthday Greeting',b'0');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (37,'No. of hall tickets generated','No. of hall tickets generated',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (38,'Credit notes generated','Credit notes generated',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (39,'No. of course enrollments','No. of course enrollments',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (40,'No. of admissions','No. of admissions',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (41,'No. of timetable sessions','No. of timetable sessions',b'1');
INSERT INTO `monthly_report_master_osm` (`id`,`gridDisplayColumn`,`summary_display_column`,`status`) VALUES (42,'Applicant profiles created','Applicant profiles created',b'1');

-- ----------------------------------------------------------------------------------------------------------------------------------------------------------------

END $$
CALL V20230715124944__Create_MonthlyReportMasterTranslationOSM () $$ 
DROP PROCEDURE IF EXISTS V20230715124944__Create_MonthlyReportMasterTranslationOSM $$ 
DELIMITER ;