DELIMITER $$
DROP PROCEDURE IF EXISTS V20230725122627__Create_StudentInsuranceDetails $$
CREATE PROCEDURE V20230725122627__Create_StudentInsuranceDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_insurance_details')) THEN 
CREATE TABLE `student_insurance_details`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint DEFAULT NULL,
`healthInsuranceConfirmed` bit(1) DEFAULT NULL,
`schoolInsuranceType` bigint DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_studentInsuranceDetail_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_studentInsuranceDetail_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_studentInsuranceDetail_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
CONSTRAINT `FK_studentInsuranceDetail_visaType_FK` FOREIGN KEY (`schoolInsuranceType`) REFERENCES `drop_down`(`id`))
ENGINE=INNODB DEFAULT  CHARSET=utf8;

END IF; 

END $$
CALL V20230725122627__Create_StudentInsuranceDetails () $$ 
DROP PROCEDURE IF EXISTS V20230725122627__Create_StudentInsuranceDetails $$ 
DELIMITER ;